/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindSubmissionSetsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindSubmissionSetsQueryTransformer
extends AbstractStoredQueryTransformer<FindSubmissionSetsQuery> {
    @Override
    public void toEbXML(FindSubmissionSetsQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromString(QueryParameter.SUBMISSION_SET_PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID, query.getSourceIds());
        slots.fromNumber(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM, Timestamp.toHL7(query.getSubmissionTime().getFrom()));
        slots.fromNumber(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO, Timestamp.toHL7(query.getSubmissionTime().getTo()));
        slots.fromString(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, query.getAuthorPerson());
        slots.fromCode(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE, query.getContentTypeCodes());
        slots.fromStatus(QueryParameter.SUBMISSION_SET_STATUS, query.getStatus());
    }

    @Override
    public void fromEbXML(FindSubmissionSetsQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        String patientId = slots.toString(QueryParameter.SUBMISSION_SET_PATIENT_ID);
        query.setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        query.setSourceIds(slots.toStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID));
        query.getSubmissionTime().setFrom(slots.toNumber(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM));
        query.getSubmissionTime().setTo(slots.toNumber(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO));
        query.setAuthorPerson(slots.toString(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON));
        query.setContentTypeCodes(slots.toCodeList(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE));
        query.setStatus(slots.toStatus(QueryParameter.SUBMISSION_SET_STATUS));
    }
}

