/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.GetByIdAndCodesQuery;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.GetFromDocumentQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public abstract class GetByIDAndCodesQueryTransformer<T extends GetByIdAndCodesQuery>
extends AbstractStoredQueryTransformer<T> {
    private final QueryParameter formatCodeParam;
    private final QueryParameter confCodeParam;
    private final QueryParameter confCodeSchemeParam;
    private final QueryParameter uniqueIdParam;
    private final QueryParameter uuidParam;

    public GetByIDAndCodesQueryTransformer(QueryParameter uuidParam, QueryParameter uniqueIdParam, QueryParameter formatCodeParam, QueryParameter formatCodeSchemeParam, QueryParameter confCodeParam, QueryParameter confCodeSchemeParam) {
        Validate.notNull((Object)((Object)uniqueIdParam), (String)"uniqueIdParam cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)uuidParam), (String)"uuidParam cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)formatCodeParam), (String)"formatCodeParam cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)formatCodeSchemeParam), (String)"formatCodeSchemeParam cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)confCodeParam), (String)"confCodeParam cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)confCodeSchemeParam), (String)"confCodeSchemeParam cannot be null", (Object[])new Object[0]);
        this.formatCodeParam = formatCodeParam;
        this.confCodeParam = confCodeParam;
        this.confCodeSchemeParam = confCodeSchemeParam;
        this.uniqueIdParam = uniqueIdParam;
        this.uuidParam = uuidParam;
    }

    @Override
    public void toEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromCode(this.formatCodeParam, ((GetByIdAndCodesQuery)query).getFormatCodes());
        slots.fromCode(this.confCodeParam, ((GetByIdAndCodesQuery)query).getConfidentialityCodes());
        slots.fromString(this.uuidParam, ((GetFromDocumentQuery)query).getUuid());
        slots.fromString(this.uniqueIdParam, ((GetFromDocumentQuery)query).getUniqueId());
    }

    @Override
    public void fromEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        ((GetByIdAndCodesQuery)query).setFormatCodes(slots.toCodeList(this.formatCodeParam));
        ((GetByIdAndCodesQuery)query).setConfidentialityCodes(slots.toCodeQueryList(this.confCodeParam, this.confCodeSchemeParam));
        ((GetFromDocumentQuery)query).setUniqueId(slots.toString(this.uniqueIdParam));
        ((GetFromDocumentQuery)query).setUuid(slots.toString(this.uuidParam));
    }
}

