/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import ca.uhn.hl7v2.model.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentAvailability;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class QuerySlotHelper {
    private final EbXMLAdhocQueryRequest ebXML;

    public QuerySlotHelper(EbXMLAdhocQueryRequest ebXML) {
        Validate.notNull((Object)ebXML, (String)"ebXML cannot be null", (Object[])new Object[0]);
        this.ebXML = ebXML;
    }

    public String toString(QueryParameter param) {
        String value = this.ebXML.getSingleSlotValue(param.getSlotName());
        return QuerySlotHelper.decodeString(value);
    }

    public void fromString(QueryParameter param, String value) {
        if (value != null) {
            this.ebXML.addSlot(param.getSlotName(), QuerySlotHelper.encodeAsString(value));
        }
    }

    public void fromCode(QueryParameter param, List<Code> codes) {
        if (codes == null) {
            return;
        }
        ArrayList<String> slotValues = new ArrayList<String>();
        for (Code code : codes) {
            String hl7CE = Hl7v2Based.render(code);
            slotValues.add(QuerySlotHelper.encodeAsStringList(hl7CE));
        }
        this.ebXML.addSlot(param.getSlotName(), slotValues.toArray(new String[0]));
    }

    public void fromCode(QueryParameter param, QueryList<Code> queryList) {
        if (queryList == null) {
            return;
        }
        for (List<Code> codes : queryList.getOuterList()) {
            this.fromCode(param, codes);
        }
    }

    private QueryList<Code> toCodeQueryList(QueryParameter param) {
        List<EbXMLSlot> slots = this.ebXML.getSlots(param.getSlotName());
        if (slots.isEmpty()) {
            return null;
        }
        QueryList<Code> queryList = new QueryList<Code>();
        for (EbXMLSlot slot : slots) {
            List<Code> innerList = QuerySlotHelper.toCode(slot.getValueList());
            queryList.getOuterList().add(innerList);
        }
        return queryList;
    }

    public QueryList<String> toStringQueryList(QueryParameter param) {
        return this.toStringQueryList(param.getSlotName());
    }

    public QueryList<String> toStringQueryList(String slotName) {
        if (StringUtils.isEmpty((CharSequence)slotName)) {
            return null;
        }
        List<EbXMLSlot> slots = this.ebXML.getSlots(slotName);
        if (slots.isEmpty()) {
            return null;
        }
        QueryList<String> queryList = new QueryList<String>();
        for (EbXMLSlot slot : slots) {
            ArrayList<String> innerList = new ArrayList<String>();
            for (String slotValue : slot.getValueList()) {
                innerList.addAll(QuerySlotHelper.decodeStringList(slotValue));
            }
            queryList.getOuterList().add(innerList);
        }
        return queryList;
    }

    public void fromStringList(QueryParameter param, List<String> values) {
        this.fromStringList(param.getSlotName(), values);
    }

    public void fromStringList(String slotName, List<String> values) {
        if (StringUtils.isEmpty((CharSequence)slotName) || values == null) {
            return;
        }
        String[] slotValues = (String[])values.stream().map(QuerySlotHelper::encodeAsStringList).toArray(String[]::new);
        this.ebXML.addSlot(slotName, slotValues);
    }

    public void fromStringList(QueryParameter param, QueryList<String> queryList) {
        this.fromStringList(param.getSlotName(), queryList);
    }

    public void fromStringList(String slotName, QueryList<String> queryList) {
        if (StringUtils.isEmpty((CharSequence)slotName) || queryList == null) {
            return;
        }
        for (List<String> list : queryList.getOuterList()) {
            this.fromStringList(slotName, list);
        }
    }

    public List<String> toStringList(QueryParameter param) {
        List<String> slotValues = this.ebXML.getSlotValues(param.getSlotName());
        if (slotValues.isEmpty()) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String slotValue : slotValues) {
            values.addAll(QuerySlotHelper.decodeStringList(slotValue));
        }
        return values;
    }

    public void fromPatientIdList(QueryParameter param, List<Identifiable> values) {
        if (values == null) {
            return;
        }
        String[] slotValues = (String[])values.stream().map(value -> QuerySlotHelper.encodeAsStringList(Hl7v2Based.render(value))).toArray(String[]::new);
        this.ebXML.addSlot(param.getSlotName(), slotValues);
    }

    public List<Identifiable> toPatientIdList(QueryParameter param) {
        List<String> values = this.toStringList(param);
        if (values == null) {
            return null;
        }
        ArrayList<Identifiable> patientIds = new ArrayList<Identifiable>();
        for (String value : values) {
            patientIds.add(Hl7v2Based.parse(value, Identifiable.class));
        }
        return patientIds;
    }

    public List<Code> toCodeList(QueryParameter param) {
        return QuerySlotHelper.toCode(this.ebXML.getSlotValues(param.getSlotName()));
    }

    public QueryList<Code> toCodeQueryList(QueryParameter param, QueryParameter schemeParam) {
        QueryList<Code> codes = this.toCodeQueryList(param);
        if (codes == null) {
            return null;
        }
        QueryList<String> schemes = this.toStringQueryList(schemeParam);
        if (schemes != null) {
            List<List<String>> schemesOuter = schemes.getOuterList();
            List<List<Code>> codesOuter = codes.getOuterList();
            for (int outer = 0; outer < schemesOuter.size() && outer < codesOuter.size(); ++outer) {
                List<String> schemesInner = schemesOuter.get(outer);
                List<Code> codesInner = codesOuter.get(outer);
                for (int inner = 0; inner < schemesInner.size() && inner < codesInner.size(); ++inner) {
                    codesInner.get(inner).setSchemeName(schemesInner.get(inner));
                }
            }
        }
        return codes;
    }

    public void fromNumber(QueryParameter param, String value) {
        this.ebXML.addSlot(param.getSlotName(), value);
    }

    public String toNumber(QueryParameter param) {
        return this.ebXML.getSingleSlotValue(param.getSlotName());
    }

    public void fromStatus(QueryParameter param, List<AvailabilityStatus> status) {
        if (status == null) {
            return;
        }
        List<String> opcodes = status.stream().map(AvailabilityStatus::toQueryOpcode).collect(Collectors.toList());
        this.fromStringList(param, opcodes);
    }

    public List<AvailabilityStatus> toStatus(QueryParameter param) {
        List<String> opcodes = this.toStringList(param);
        if (opcodes == null) {
            return null;
        }
        ArrayList<AvailabilityStatus> list = new ArrayList<AvailabilityStatus>();
        for (String opcode : opcodes) {
            AvailabilityStatus status = AvailabilityStatus.valueOfOpcode(opcode);
            if (status == null) continue;
            list.add(status);
        }
        return list;
    }

    public void fromAssociationType(QueryParameter param, List<AssociationType> associationTypes) {
        if (associationTypes == null) {
            return;
        }
        List<String> opcodes = associationTypes.stream().map(type -> AssociationType.getOpcode30(type)).collect(Collectors.toList());
        this.fromStringList(param, opcodes);
    }

    public List<AssociationType> toAssociationType(QueryParameter param) {
        List<String> opcodes = this.toStringList(param);
        if (opcodes == null) {
            return null;
        }
        return opcodes.stream().map(AssociationType::valueOfOpcode30).collect(Collectors.toList());
    }

    public void fromDocumentEntryType(QueryParameter param, List<DocumentEntryType> documentEntryTypes) {
        if (documentEntryTypes == null) {
            return;
        }
        List<String> uuids = documentEntryTypes.stream().map(DocumentEntryType::toUuid).collect(Collectors.toList());
        this.fromStringList(param, uuids);
    }

    public List<DocumentEntryType> toDocumentEntryType(QueryParameter param) {
        List<String> uuids = this.toStringList(param);
        if (uuids == null) {
            return null;
        }
        return uuids.stream().map(DocumentEntryType::valueOfUuid).collect(Collectors.toList());
    }

    public static List<Code> toCode(List<String> slotValues) {
        if (slotValues.isEmpty()) {
            return null;
        }
        ArrayList<Code> codes = new ArrayList<Code>();
        for (String slotValue : slotValues) {
            for (String hl7CE : QuerySlotHelper.decodeStringList(slotValue)) {
                Code code = Hl7v2Based.parse(hl7CE, Code.class);
                if (code == null || StringUtils.isEmpty((CharSequence)code.getCode()) || StringUtils.isEmpty((CharSequence)code.getSchemeName())) {
                    throw new XDSMetaDataException(ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, hl7CE);
                }
                codes.add(code);
            }
        }
        return codes;
    }

    public void fromDocumentAvailability(QueryParameter param, List<DocumentAvailability> status) {
        if (status == null) {
            return;
        }
        List<String> opcodes = status.stream().map(DocumentAvailability::toFullQualifiedOpcode).collect(Collectors.toList());
        this.fromStringList(param, opcodes);
    }

    public List<DocumentAvailability> toDocumentAvailability(QueryParameter param) {
        List<String> opcodes = this.toStringList(param);
        if (opcodes == null) {
            return null;
        }
        ArrayList<DocumentAvailability> list = new ArrayList<DocumentAvailability>();
        for (String opcode : opcodes) {
            DocumentAvailability availability = DocumentAvailability.valueOfOpcode(opcode);
            if (availability == null) continue;
            list.add(availability);
        }
        return list;
    }

    public void fromInteger(QueryParameter param, Integer value) {
        if (value == null) {
            return;
        }
        this.ebXML.addSlot(param.getSlotName(), String.valueOf(value));
    }

    public Integer toInteger(QueryParameter param) {
        Integer result = null;
        try {
            String slotValue = this.ebXML.getSingleSlotValue(param.getSlotName());
            if (StringUtils.isNotBlank((CharSequence)slotValue)) {
                result = Integer.valueOf(slotValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static String encodeAsString(String value) {
        if (value == null) {
            return null;
        }
        return "'" + value.replace("'", "''") + "'";
    }

    public static String decodeString(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        return value.replaceAll("''", "'");
    }

    public static String encodeAsStringList(String value) {
        if (value == null) {
            return null;
        }
        return "('" + value.replace("'", "''") + "')";
    }

    public static List<String> decodeStringList(String list) {
        if (list == null) {
            return null;
        }
        if ((list = list.trim()).startsWith("(")) {
            list = list.substring(1);
        }
        if (list.endsWith(")")) {
            list = list.substring(0, list.length() - 1);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (String value : list.split(",")) {
            String decodedValue = StringUtils.isNotBlank((CharSequence)value) ? QuerySlotHelper.decodeString(value.trim()) : "";
            values.add(decodedValue);
        }
        return values;
    }

    public static <T extends Hl7v2Based> QueryList<String> render(QueryList<T> source) {
        if (source == null) {
            return null;
        }
        Validate.noNullElements(source.getOuterList(), (String)"outer list cannot contain NULL elements", (Object[])new Object[0]);
        QueryList<String> target = new QueryList<String>();
        source.getOuterList().forEach(list -> target.getOuterList().add(QuerySlotHelper.render(list)));
        return target;
    }

    public static <T extends Hl7v2Based> List<String> render(List<T> source) {
        if (source == null) {
            return null;
        }
        Validate.noNullElements(source, (String)"list cannot contain NULL elements", (Object[])new Object[0]);
        return source.stream().map(Hl7v2Based::render).collect(Collectors.toList());
    }

    public static <C extends Composite, T extends Hl7v2Based<C>> QueryList<T> parse(QueryList<String> source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        Validate.noNullElements(source.getOuterList(), (String)"outer list cannot contain NULL elements", (Object[])new Object[0]);
        QueryList target = new QueryList();
        source.getOuterList().forEach(list -> target.getOuterList().add(QuerySlotHelper.parse(list, targetClass)));
        return target;
    }

    public static <C extends Composite, T extends Hl7v2Based<C>> List<T> parse(List<String> source, Class<T> targetClass) {
        if (source == null) {
            return null;
        }
        Validate.noNullElements(source, (String)"list cannot contain NULL elements", (Object[])new Object[0]);
        return source.stream().map(value -> Hl7v2Based.parse(value, targetClass)).collect(Collectors.toList());
    }
}

