/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import javax.activation.DataHandler;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAssociation;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLQueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ObjectReference;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.responses.QueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.AssociationTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.DocumentEntryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.FolderTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.SubmissionSetTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.responses.ErrorInfoListTransformer;

public class QueryResponseTransformer {
    private final EbXMLFactory factory;
    private final SubmissionSetTransformer submissionSetTransformer;
    private final DocumentEntryTransformer documentEntryTransformer;
    private final FolderTransformer folderTransformer;
    private final AssociationTransformer associationTransformer;
    private final ErrorInfoListTransformer errorInfoListTransformer;

    public QueryResponseTransformer(EbXMLFactory factory) {
        Validate.notNull((Object)factory, (String)"factory cannot be null", (Object[])new Object[0]);
        this.factory = factory;
        this.submissionSetTransformer = new SubmissionSetTransformer(factory);
        this.documentEntryTransformer = new DocumentEntryTransformer(factory);
        this.folderTransformer = new FolderTransformer(factory);
        this.associationTransformer = new AssociationTransformer(factory);
        this.errorInfoListTransformer = new ErrorInfoListTransformer(factory);
    }

    public EbXMLQueryResponse toEbXML(QueryResponse response) {
        if (response == null) {
            return null;
        }
        EbXMLObjectLibrary library = this.factory.createObjectLibrary();
        EbXMLQueryResponse ebXML = this.factory.createAdhocQueryResponse(library, !response.getReferences().isEmpty());
        ebXML.setStatus(response.getStatus());
        if (!response.getErrors().isEmpty()) {
            ebXML.setErrors(this.errorInfoListTransformer.toEbXML(response.getErrors()));
        }
        for (DocumentEntry docEntry : response.getDocumentEntries()) {
            EbXMLExtrinsicObject extrinsic = (EbXMLExtrinsicObject)this.documentEntryTransformer.toEbXML(docEntry, library);
            for (Document document : response.getDocuments()) {
                if (document == null || document.getDocumentEntry() != docEntry) continue;
                extrinsic.setDataHandler((DataHandler)document.getContent(DataHandler.class));
                break;
            }
            ebXML.addExtrinsicObject(extrinsic);
        }
        for (Folder folder : response.getFolders()) {
            ebXML.addRegistryPackage((EbXMLRegistryPackage)this.folderTransformer.toEbXML(folder, library));
            this.addClassification(ebXML, folder.getEntryUuid(), "urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2", library);
        }
        for (SubmissionSet set : response.getSubmissionSets()) {
            ebXML.addRegistryPackage((EbXMLRegistryPackage)this.submissionSetTransformer.toEbXML(set, library));
            this.addClassification(ebXML, set.getEntryUuid(), "urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd", library);
        }
        for (Association association : response.getAssociations()) {
            ebXML.addAssociation(this.associationTransformer.toEbXML(association, library));
        }
        response.getReferences().forEach(ebXML::addReference);
        return ebXML;
    }

    public QueryResponse fromEbXML(EbXMLQueryResponse ebXML) {
        if (ebXML == null) {
            return null;
        }
        QueryResponse response = new QueryResponse();
        response.setStatus(ebXML.getStatus());
        if (!ebXML.getErrors().isEmpty()) {
            response.setErrors(this.errorInfoListTransformer.fromEbXML(ebXML.getErrors()));
        }
        boolean foundNonObjRefs = false;
        for (EbXMLExtrinsicObject extrinsic : ebXML.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND)) {
            DocumentEntry documentEntry = (DocumentEntry)this.documentEntryTransformer.fromEbXML(extrinsic);
            response.getDocumentEntries().add(documentEntry);
            if (extrinsic.getDataHandler() != null) {
                response.getDocuments().add(new Document(documentEntry, extrinsic.getDataHandler()));
            }
            foundNonObjRefs = true;
        }
        for (EbXMLRegistryPackage regPackage : ebXML.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
            response.getFolders().add((Folder)this.folderTransformer.fromEbXML(regPackage));
            foundNonObjRefs = true;
        }
        for (EbXMLRegistryPackage regPackage : ebXML.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd")) {
            response.getSubmissionSets().add((SubmissionSet)this.submissionSetTransformer.fromEbXML(regPackage));
            foundNonObjRefs = true;
        }
        for (EbXMLAssociation association : ebXML.getAssociations()) {
            response.getAssociations().add(this.associationTransformer.fromEbXML(association));
            foundNonObjRefs = true;
        }
        if (!foundNonObjRefs) {
            EbXMLObjectLibrary standardLibrary = this.factory.createObjectLibrary();
            ebXML.getReferences().stream().filter(ref -> standardLibrary.getById(ref.getId()) == null).forEach(ref -> response.getReferences().add((ObjectReference)ref));
        }
        return response;
    }

    private void addClassification(EbXMLQueryResponse ebXML, String classified, String node, EbXMLObjectLibrary library) {
        EbXMLClassification classification = this.factory.createClassification(library);
        classification.setClassifiedObject(classified);
        classification.setClassificationNode(node);
        classification.assignUniqueId();
        ebXML.addClassification(classification);
    }
}

