/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.transform.responses.ErrorInfoListTransformer;

public class ResponseTransformer {
    private final EbXMLFactory factory;
    private final ErrorInfoListTransformer errorInfoListTransformer;

    public ResponseTransformer(EbXMLFactory factory) {
        Validate.notNull((Object)factory, (String)"factory cannot be null", (Object[])new Object[0]);
        this.factory = factory;
        this.errorInfoListTransformer = new ErrorInfoListTransformer(factory);
    }

    public EbXMLRegistryResponse toEbXML(Response response) {
        Validate.notNull((Object)response, (String)"response cannot be null", (Object[])new Object[0]);
        EbXMLRegistryResponse ebXML = this.factory.createRegistryResponse();
        ebXML.setStatus(response.getStatus());
        if (!response.getErrors().isEmpty()) {
            ebXML.setErrors(this.errorInfoListTransformer.toEbXML(response.getErrors()));
        }
        return ebXML;
    }

    public Response fromEbXML(EbXMLRegistryResponse ebXML) {
        Validate.notNull((Object)ebXML, (String)"ebXML cannot be null", (Object[])new Object[0]);
        Response response = new Response();
        response.setStatus(ebXML.getStatus());
        if (!ebXML.getErrors().isEmpty()) {
            response.setErrors(this.errorInfoListTransformer.fromEbXML(ebXML.getErrors()));
        }
        return response;
    }
}

