/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HL7ValidationUtils;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class CXValidator
implements ValueValidator {
    private static final HDValidator HD_VALIDATOR = new HDValidator();
    private final boolean assigningAuthorityRequired;

    public CXValidator(boolean assigningAuthorityRequired) {
        this.assigningAuthorityRequired = assigningAuthorityRequired;
    }

    @Override
    public void validate(String hl7CX) throws XDSMetaDataException {
        Identifiable identifiable = Hl7v2Based.parse(hl7CX, Identifiable.class);
        ValidatorAssertions.metaDataAssert(identifiable != null, ValidationMessage.CX_NEEDS_ID, new Object[0]);
        CX cx = (CX)identifiable.getHapiObject();
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx2_CheckDigit().getValue()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx3_CheckDigitScheme().getValue()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx5_IdentifierTypeCode().getValue()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx6_AssigningFacility()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx7_EffectiveDate().getValue()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx8_ExpirationDate().getValue()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx9_AssigningJurisdiction()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx10_AssigningAgencyOrDepartment()), ValidationMessage.CX_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)cx.getCx1_IDNumber().getValue()), ValidationMessage.CX_NEEDS_ID, hl7CX);
        HD assigningAuthority = cx.getCx4_AssigningAuthority();
        if (this.assigningAuthorityRequired || !HL7ValidationUtils.isEmptyField(assigningAuthority)) {
            HD_VALIDATOR.validate(assigningAuthority, hl7CX);
        }
    }
}

