/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RegistryObjectValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class ExternalIdentifierValidation
implements RegistryObjectValidator {
    private final String scheme;
    private final ValueValidator validator;

    public ExternalIdentifierValidation(String scheme, ValueValidator validator) {
        this.scheme = scheme;
        this.validator = validator;
    }

    @Override
    public void validate(EbXMLRegistryObject obj) throws XDSMetaDataException {
        String value = obj.getExternalIdentifierValue(this.scheme);
        ValidatorAssertions.metaDataAssert(value != null, ValidationMessage.MISSING_EXTERNAL_IDENTIFIER, this.scheme);
        this.validator.validate(value);
    }
}

