/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import ca.uhn.hl7v2.model.v25.datatype.HD;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.validate.OIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class HDValidator {
    private static final OIDValidator OID_VALIDATOR = new OIDValidator();

    public void validate(HD hd, String original) {
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)hd.getHd1_NamespaceID().getValue()), ValidationMessage.HD_MUST_NOT_HAVE_NAMESPACE_ID, original);
        ValidatorAssertions.metaDataAssert("ISO".equals(hd.getHd3_UniversalIDType().getValue()), ValidationMessage.UNIVERSAL_ID_TYPE_MUST_BE_ISO, original);
        String oid = hd.getHd2_UniversalID().getValue();
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)oid), ValidationMessage.HD_NEEDS_UNIVERSAL_ID, original);
        OID_VALIDATOR.validate(oid);
    }
}

