/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class OIDValidator
implements ValueValidator {
    private static final Pattern OID_PATTERN = Pattern.compile("[1-9][0-9]*(\\.(0|([1-9][0-9]*)))+");

    @Override
    public void validate(String oid) throws XDSMetaDataException {
        Validate.notNull((Object)oid, (String)"oid cannot be null", (Object[])new Object[0]);
        ValidatorAssertions.metaDataAssert(oid.length() <= 64, ValidationMessage.OID_TOO_LONG, oid);
        ValidatorAssertions.metaDataAssert(OID_PATTERN.matcher(oid).matches(), ValidationMessage.INVALID_OID, oid);
    }
}

