/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueListValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XCNValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XONValidator;

public class RecipientListValidator
implements ValueListValidator {
    private final XCNValidator xcnValidator = new XCNValidator();
    private final XONValidator xonValidator = new XONValidator();

    @Override
    public void validate(List<String> values) throws XDSMetaDataException {
        Validate.noNullElements(values, (String)"values cannot contain null elements", (Object[])new Object[0]);
        for (String value : values) {
            ValidatorAssertions.metaDataAssert(!value.isEmpty(), ValidationMessage.RECIPIENT_EMPTY, new Object[0]);
            String[] parts = value.split("\\|", 4);
            ValidatorAssertions.metaDataAssert(parts.length > 0 && parts.length <= 3, ValidationMessage.INVALID_RECIPIENT, value);
            if (!parts[0].isEmpty()) {
                this.xonValidator.validate(parts[0]);
            }
            if (parts.length <= 1 || parts[1].isEmpty()) continue;
            this.xcnValidator.validate(parts[1]);
        }
    }
}

