/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlotList;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RegistryObjectValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class SlotValueValidation
implements RegistryObjectValidator {
    private final String slotName;
    private final ValueValidator validator;
    private final int min;
    private final int max;

    public SlotValueValidation(String slotName, ValueValidator validator, int min, int max) {
        this.slotName = slotName;
        this.validator = validator;
        this.min = min;
        this.max = max;
    }

    public SlotValueValidation(String slotName, ValueValidator validator) {
        this.slotName = slotName;
        this.validator = validator;
        this.min = 1;
        this.max = 1;
    }

    @Override
    public void validate(EbXMLRegistryObject obj) throws XDSMetaDataException {
        this.validate((EbXMLSlotList)obj);
    }

    public void validate(EbXMLSlotList slotList) throws XDSMetaDataException {
        List<String> slotValues = slotList.getSlotValues(this.slotName);
        ValidatorAssertions.metaDataAssert(slotValues.size() >= this.min && slotValues.size() <= this.max, ValidationMessage.WRONG_NUMBER_OF_SLOT_VALUES, this.slotName, this.min, this.max, slotValues.size());
        for (String value : slotValues) {
            ValidatorAssertions.metaDataAssert(value != null, ValidationMessage.EMPTY_SLOT_VALUE, this.slotName);
            this.validator.validate(value);
        }
    }
}

