/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.URN;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class UUIDValidator
implements ValueValidator {
    private static final Pattern UUID_PATTERN = Pattern.compile(".*[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");

    @Override
    public void validate(String uuid) throws XDSMetaDataException {
        Validate.notNull((Object)uuid, (String)"uuid cannot be null", (Object[])new Object[0]);
        ValidatorAssertions.metaDataAssert(UUID_PATTERN.matcher(uuid).matches(), ValidationMessage.INVALID_UUID, uuid);
    }

    public Optional<String> getSymbolicId(String id) {
        return !this.isUUID(id) ? Optional.of(id) : Optional.empty();
    }

    public boolean isUUID(String id) {
        return this.getAsUUID(id).isPresent();
    }

    public Optional<UUID> getAsUUID(String urn) {
        try {
            return Optional.of(UUID.fromString(urn.substring("urn:uuid:".length())));
        }
        catch (RuntimeException e) {
            return Optional.empty();
        }
    }

    public Optional<UUID> getAsUUID(URI uri) {
        return this.getAsUUID(uri.toString());
    }

    public Optional<UUID> getAsUUID(URN urn) {
        return this.getAsUUID(urn.toString());
    }
}

