/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class AssociationValidation
implements QueryParameterValidation {
    private static final Pattern PATTERN = Pattern.compile("\\s*\\(\\s*'.*'(\\s*,\\s*'.*')*\\s*\\)\\s*");
    private final QueryParameter param;

    public AssociationValidation(QueryParameter param) {
        Validate.notNull((Object)((Object)param), (String)"param cannot be null", (Object[])new Object[0]);
        this.param = param;
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest request) throws XDSMetaDataException {
        List<String> slotValues = request.getSlotValues(this.param.getSlotName());
        ValidatorAssertions.metaDataAssert(!slotValues.isEmpty(), ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
        for (String slotValue : slotValues) {
            ValidatorAssertions.metaDataAssert(slotValue != null, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
            ValidatorAssertions.metaDataAssert(PATTERN.matcher(slotValue).matches(), ValidationMessage.PARAMETER_VALUE_NOT_STRING_LIST, new Object[]{this.param});
        }
        QuerySlotHelper slots = new QuerySlotHelper(request);
        List<AssociationType> associationTypes = slots.toAssociationType(this.param);
        if (associationTypes != null) {
            for (AssociationType type : associationTypes) {
                ValidatorAssertions.metaDataAssert(type != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
            }
        } else {
            throw new XDSMetaDataException(ValidationMessage.INVALID_ASSOCIATION_TYPE, new Object[0]);
        }
    }
}

