/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class QueryListCodeValidation
implements QueryParameterValidation {
    private static final Pattern PATTERN = Pattern.compile("\\s*\\(\\s*'.*'(\\s*,\\s*'.*')*\\s*\\)\\s*");
    private final QueryParameter param;
    private final QueryParameter schemeParam;

    public QueryListCodeValidation(QueryParameter param, QueryParameter schemeParam) {
        Validate.notNull((Object)((Object)param), (String)"param cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)schemeParam), (String)"schemeParam cannot be null", (Object[])new Object[0]);
        this.param = param;
        this.schemeParam = schemeParam;
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest request) throws XDSMetaDataException {
        List<String> slotValues = request.getSlotValues(this.param.getSlotName());
        for (String slotValue : slotValues) {
            ValidatorAssertions.metaDataAssert(slotValue != null, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
            ValidatorAssertions.metaDataAssert(PATTERN.matcher(slotValue).matches(), ValidationMessage.PARAMETER_VALUE_NOT_STRING_LIST, new Object[]{this.param});
        }
        QuerySlotHelper slots = new QuerySlotHelper(request);
        QueryList<Code> codes = slots.toCodeQueryList(this.param, this.schemeParam);
        if (codes != null) {
            QueryList<String> schemes = slots.toStringQueryList(this.schemeParam);
            if (schemes != null) {
                ValidatorAssertions.metaDataAssert(codes.getOuterList().size() == schemes.getOuterList().size(), ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.schemeParam});
                for (int idx = 0; idx < codes.getOuterList().size(); ++idx) {
                    ValidatorAssertions.metaDataAssert(codes.getOuterList().get(idx).size() == schemes.getOuterList().get(idx).size(), ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.schemeParam});
                }
            }
            for (List<Code> innerList : codes.getOuterList()) {
                for (Code code : innerList) {
                    ValidatorAssertions.metaDataAssert(code != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
                    ValidatorAssertions.metaDataAssert(code.getCode() != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
                }
            }
        } else {
            QueryList<String> schemes = slots.toStringQueryList(this.schemeParam);
            ValidatorAssertions.metaDataAssert(schemes == null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.schemeParam});
        }
    }
}

