/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class StringValidation
implements QueryParameterValidation {
    private static final Pattern PATTERN = Pattern.compile("'.*'");
    private final QueryParameter param;
    private final ValueValidator validator;
    private final boolean optional;

    public StringValidation(QueryParameter param, ValueValidator validator, boolean optional) {
        Validate.notNull((Object)((Object)param), (String)"param cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)validator, (String)"validator cannot be null", (Object[])new Object[0]);
        this.param = param;
        this.validator = validator;
        this.optional = optional;
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest request) throws XDSMetaDataException {
        QuerySlotHelper slots;
        String value;
        List<String> slotValues = request.getSlotValues(this.param.getSlotName());
        ValidatorAssertions.metaDataAssert(this.optional || slotValues.size() >= 1, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
        ValidatorAssertions.metaDataAssert(this.optional || slotValues.size() == 1, ValidationMessage.TOO_MANY_VALUES_FOR_QUERY_PARAMETER, new Object[]{this.param});
        if (slotValues.size() > 0) {
            String slotValue = slotValues.get(0);
            ValidatorAssertions.metaDataAssert(slotValue != null || this.optional, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
            ValidatorAssertions.metaDataAssert(PATTERN.matcher(slotValue).matches(), ValidationMessage.PARAMETER_VALUE_NOT_STRING, new Object[]{this.param});
        }
        ValidatorAssertions.metaDataAssert((value = (slots = new QuerySlotHelper(request)).toString(this.param)) != null || this.optional, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
        if (value != null) {
            this.validator.validate(value);
        }
    }
}

