/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRetrieveImagingDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.requests.DocumentReference;
import org.openehealth.ipf.commons.ihe.xds.core.requests.RetrieveSeries;
import org.openehealth.ipf.commons.ihe.xds.core.requests.RetrieveStudy;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class RetrieveImagingDocumentSetRequestValidator
implements Validator<EbXMLRetrieveImagingDocumentSetRequest, ValidationProfile> {
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);

    public void validate(EbXMLRetrieveImagingDocumentSetRequest request, ValidationProfile profile) {
        Validate.notNull((Object)request, (String)"request cannot be null", (Object[])new Object[0]);
        for (RetrieveStudy retrieveStudy : request.getRetrieveStudies()) {
            String studyInstanceUID = retrieveStudy.getStudyInstanceUID();
            ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)studyInstanceUID), ValidationMessage.STUDY_INSTANCE_UID_MUST_BE_SPECIFIED, new Object[0]);
            List<String> transferSyntaxUIDList = request.getTransferSyntaxUIDList();
            ValidatorAssertions.metaDataAssert(transferSyntaxUIDList != null && !transferSyntaxUIDList.isEmpty(), ValidationMessage.TRANSFER_SYNTAX_UID_LIST_MUST_BE_SPECIFIED, new Object[0]);
            for (RetrieveSeries retrieveSeries : retrieveStudy.getRetrieveSerieses()) {
                String seriesInstanceUID = retrieveSeries.getSeriesInstanceUID();
                ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)seriesInstanceUID), ValidationMessage.SERIES_INSTANCE_UID_MUST_BE_SPECIFIED, new Object[0]);
                for (DocumentReference document : retrieveSeries.getDocuments()) {
                    String repoId = document.getRepositoryUniqueId();
                    ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)repoId), ValidationMessage.REPO_ID_MUST_BE_SPECIFIED, new Object[0]);
                    String docId = document.getDocumentUniqueId();
                    ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)docId), ValidationMessage.DOC_ID_MUST_BE_SPECIFIED, new Object[0]);
                    if (!profile.getInteractionProfile().requiresHomeCommunityId()) continue;
                    this.hcValidator.validate(document.getHomeCommunityId());
                }
            }
        }
    }
}

