/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLRegistryResponse30;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryResponseType;

public abstract class XdsAuditStrategy<T extends XdsAuditDataset>
extends AuditStrategySupport<T> {
    public XdsAuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    private static EventOutcomeIndicator getEventOutcomeCodeFromRegistryResponse(EbXMLRegistryResponse response) {
        try {
            if (response.getStatus() == Status.SUCCESS) {
                return EventOutcomeIndicator.Success;
            }
            if (response.getErrors().isEmpty()) {
                return EventOutcomeIndicator.SeriousFailure;
            }
            for (EbXMLRegistryError error : response.getErrors()) {
                if (error.getSeverity() != Severity.ERROR) continue;
                return EventOutcomeIndicator.SeriousFailure;
            }
            return EventOutcomeIndicator.MinorFailure;
        }
        catch (Exception e) {
            return EventOutcomeIndicator.SeriousFailure;
        }
    }

    private static String getEventOutcomeDescriptionFromRegistryResponse(EbXMLRegistryResponse response) {
        if (response.getErrors().isEmpty()) {
            return null;
        }
        for (EbXMLRegistryError error : response.getErrors()) {
            if (error.getSeverity() != Severity.ERROR) continue;
            return error.getCodeContext();
        }
        return response.getErrors().get(0).getCodeContext();
    }

    public EventOutcomeIndicator getEventOutcomeIndicator(Object pojo) {
        RegistryResponseType response = (RegistryResponseType)pojo;
        EbXMLRegistryResponse30 ebXML = new EbXMLRegistryResponse30(response);
        return XdsAuditStrategy.getEventOutcomeCodeFromRegistryResponse(ebXML);
    }

    public String getEventOutcomeDescription(Object pojo) {
        RegistryResponseType response = (RegistryResponseType)pojo;
        EbXMLRegistryResponse30 ebXML = new EbXMLRegistryResponse30(response);
        return XdsAuditStrategy.getEventOutcomeDescriptionFromRegistryResponse(ebXML);
    }

    public boolean enrichAuditDatasetFromResponse(T auditDataset, Object response, AuditContext auditContext) {
        EventOutcomeIndicator outcomeCodes = this.getEventOutcomeIndicator(response);
        auditDataset.setEventOutcomeIndicator(outcomeCodes);
        auditDataset.setEventOutcomeDescription(this.getEventOutcomeDescription(response));
        return outcomeCodes == EventOutcomeIndicator.Success;
    }
}

