/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditStrategy;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsQueryAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLAdhocQueryRequest30;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.AdhocQueryType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public abstract class XdsQueryAuditStrategy30
extends XdsAuditStrategy<XdsQueryAuditDataset> {
    private static final EnumSet<QueryParameter> PATIENT_QUERY_PARAMS = EnumSet.of(QueryParameter.DOC_ENTRY_PATIENT_ID, QueryParameter.FOLDER_PATIENT_ID, QueryParameter.SUBMISSION_SET_PATIENT_ID, QueryParameter.PATIENT_ID);

    public XdsQueryAuditStrategy30(boolean serverSide) {
        super(serverSide);
    }

    public XdsQueryAuditDataset enrichAuditDatasetFromRequest(XdsQueryAuditDataset auditDataset, Object pojo, Map<String, Object> parameters) {
        if (pojo instanceof AdhocQueryRequest) {
            AdhocQueryRequest request = (AdhocQueryRequest)pojo;
            AdhocQueryType adHocQuery = request.getAdhocQuery();
            if (adHocQuery != null) {
                auditDataset.setQueryUuid(adHocQuery.getId());
                auditDataset.setHomeCommunityId(adHocQuery.getHome());
            }
            QuerySlotHelper slotHelper = new QuerySlotHelper(new EbXMLAdhocQueryRequest30(request));
            PATIENT_QUERY_PARAMS.stream().map(slotHelper::toStringList).filter(Objects::nonNull).forEach(p -> auditDataset.getPatientIds().addAll((Collection<String>)p));
        }
        return auditDataset;
    }

    public XdsQueryAuditDataset createAuditDataset() {
        return new XdsQueryAuditDataset(this.isServerSide());
    }
}

