/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditStrategy30;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryResponseType;

public abstract class XdsRemoveDocumentAuditStrategy30
extends XdsNonconstructiveDocumentSetRequestAuditStrategy30 {
    public XdsRemoveDocumentAuditStrategy30(boolean serverSide) {
        super(serverSide);
    }

    @Override
    public XdsNonconstructiveDocumentSetRequestAuditDataset.Status getDefaultDocumentStatus() {
        return XdsNonconstructiveDocumentSetRequestAuditDataset.Status.SUCCESSFUL;
    }

    @Override
    public boolean enrichAuditDatasetFromResponse(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, Object pojo, AuditContext auditContext) {
        if (pojo instanceof RegistryResponseType) {
            RegistryResponseType response = (RegistryResponseType)pojo;
            if (Status.FAILURE.getOpcode30().equals(response.getStatus())) {
                auditDataset.getDocuments().forEach(x -> x.setStatus(XdsNonconstructiveDocumentSetRequestAuditDataset.Status.NOT_SUCCESSFUL));
            } else if (Status.PARTIAL_SUCCESS.getOpcode30().equals(response.getStatus()) && response.getRegistryErrorList() != null && response.getRegistryErrorList().getRegistryError() != null) {
                for (RegistryError error : response.getRegistryErrorList().getRegistryError()) {
                    if (!Severity.ERROR.getOpcode30().equals(error.getSeverity())) continue;
                    auditDataset.getDocuments().stream().filter(document -> error.getCodeContext().contains(document.getDocumentUniqueId())).findAny().ifPresent(document -> document.setStatus(XdsNonconstructiveDocumentSetRequestAuditDataset.Status.NOT_SUCCESSFUL));
                }
            }
        }
        return true;
    }
}

