/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditStrategy;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsSubmitAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSubmitObjectsRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLSubmitObjectsRequest30;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.lcm.SubmitObjectsRequest;

public abstract class XdsSubmitAuditStrategy30
extends XdsAuditStrategy<XdsSubmitAuditDataset> {
    public XdsSubmitAuditStrategy30(boolean serverSide) {
        super(serverSide);
    }

    protected static void enrichDatasetFromSubmitObjectsRequest(XdsSubmitAuditDataset auditDataset, EbXMLSubmitObjectsRequest ebXML) {
        List<EbXMLRegistryPackage> submissionSets = ebXML.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        auditDataset.setHomeCommunityId(ebXML.getSingleSlotValue("homeCommunityId"));
        submissionSets.forEach(submissionSet -> {
            String patientId = submissionSet.getExternalIdentifierValue("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446");
            auditDataset.getPatientIds().add(patientId);
            String uniqueId = submissionSet.getExternalIdentifierValue("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8");
            auditDataset.setSubmissionSetUuid(uniqueId);
            if (auditDataset.getHomeCommunityId() == null) {
                auditDataset.setHomeCommunityId(submissionSet.getHome());
            }
        });
    }

    public XdsSubmitAuditDataset enrichAuditDatasetFromRequest(XdsSubmitAuditDataset auditDataset, Object pojo, Map<String, Object> parameters) {
        if (pojo instanceof SubmitObjectsRequest) {
            SubmitObjectsRequest submitObjectsRequest = (SubmitObjectsRequest)pojo;
            EbXMLSubmitObjectsRequest30 ebXML = new EbXMLSubmitObjectsRequest30(submitObjectsRequest);
            XdsSubmitAuditStrategy30.enrichDatasetFromSubmitObjectsRequest(auditDataset, ebXML);
        }
        return auditDataset;
    }

    public XdsSubmitAuditDataset createAuditDataset() {
        return new XdsSubmitAuditDataset(this.isServerSide());
    }
}

