/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit.event;

import java.util.Collections;
import java.util.stream.IntStream;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.DicomInstancesAccessedAuditBuilder;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsSubmitAuditDataset;

public class DicomInstancesAccessedEventBuilder
extends DicomInstancesAccessedAuditBuilder<DicomInstancesAccessedEventBuilder> {
    public DicomInstancesAccessedEventBuilder(AuditContext auditContext, AuditDataset auditDataset, EventOutcomeIndicator eventOutcomeIndicator, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, auditDataset, eventOutcomeIndicator, eventOutcomeDescription, eventActionCode, eventType, purposesOfUse);
    }

    public DicomInstancesAccessedEventBuilder setSubmissionSet(XdsSubmitAuditDataset auditDataset) {
        return (DicomInstancesAccessedEventBuilder)this.addExportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, Collections.emptyList());
    }

    public DicomInstancesAccessedEventBuilder setSubmissionSetWithHomeCommunityId(XdsSubmitAuditDataset auditDataset, boolean xcaHomeCommunityId) {
        return (DicomInstancesAccessedEventBuilder)this.addExportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, this.documentDetails(null, auditDataset.getHomeCommunityId(), null, null, xcaHomeCommunityId));
    }

    public DicomInstancesAccessedEventBuilder addDocumentIds(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, XdsNonconstructiveDocumentSetRequestAuditDataset.Status status, boolean xcaHomeCommunityId) {
        String[] documentIds = auditDataset.getDocumentIds(status);
        String[] homeCommunityIds = auditDataset.getHomeCommunityIds(status);
        String[] repositoryIds = auditDataset.getRepositoryIds(status);
        String[] seriesInstanceIds = auditDataset.getSeriesInstanceIds(status);
        String[] studyInstanceIds = auditDataset.getStudyInstanceIds(status);
        IntStream.range(0, documentIds.length).forEach(i -> this.addExportedEntity(documentIds[i], (ParticipantObjectIdType)ParticipantObjectIdTypeCode.ReportNumber, ParticipantObjectTypeCodeRole.Report, this.documentDetails(repositoryIds[i], homeCommunityIds[i], seriesInstanceIds[i], studyInstanceIds[i], xcaHomeCommunityId)));
        return (DicomInstancesAccessedEventBuilder)this.self();
    }

    public DicomInstancesAccessedEventBuilder addTransferredStudy(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, XdsNonconstructiveDocumentSetRequestAuditDataset.Status status, boolean xcaHomeCommunityId) {
        String[] documentIds = auditDataset.getDocumentIds(status);
        String[] homeCommunityIds = auditDataset.getHomeCommunityIds(status);
        String[] repositoryIds = auditDataset.getRepositoryIds(status);
        String[] seriesInstanceIds = auditDataset.getSeriesInstanceIds(status);
        String[] studyInstanceIds = auditDataset.getStudyInstanceIds(status);
        IntStream.range(0, studyInstanceIds.length).forEach(i -> this.addTransferredStudyParticipantObject(studyInstanceIds[i], this.dicomDetails(repositoryIds[i], homeCommunityIds[i], documentIds[i], seriesInstanceIds[i], xcaHomeCommunityId)));
        return (DicomInstancesAccessedEventBuilder)this.self();
    }
}

