/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLQueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLFactory30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLObjectContainer30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLRegistryError30;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ObjectReference;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.IdentifiableType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ObjectRefType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.RegistryObjectListType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryErrorList;

public class EbXMLQueryResponse30
extends EbXMLObjectContainer30
implements EbXMLQueryResponse {
    private final AdhocQueryResponse response;

    public EbXMLQueryResponse30(AdhocQueryResponse response, EbXMLObjectLibrary objectLibrary) {
        super(objectLibrary);
        Validate.notNull((Object)response, (String)"response cannot be null", (Object[])new Object[0]);
        this.response = response;
    }

    public EbXMLQueryResponse30(AdhocQueryResponse response) {
        this(response, new EbXMLObjectLibrary());
        this.fillObjectLibrary();
    }

    @Override
    List<JAXBElement<? extends IdentifiableType>> getContents() {
        RegistryObjectListType list = this.response.getRegistryObjectList();
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getIdentifiable();
    }

    @Override
    public Status getStatus() {
        return Status.valueOfOpcode(this.response.getStatus());
    }

    @Override
    public void setStatus(Status status) {
        this.response.setStatus(Status.getOpcode30(status));
    }

    @Override
    public List<EbXMLRegistryError> getErrors() {
        RegistryErrorList list = this.response.getRegistryErrorList();
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getRegistryError().stream().map(EbXMLRegistryError30::new).collect(Collectors.toList());
    }

    @Override
    public void setErrors(List<EbXMLRegistryError> errors) {
        RegistryErrorList value = EbXMLFactory30.RS_FACTORY.createRegistryErrorList();
        this.response.setRegistryErrorList(value);
        List<RegistryError> list = value.getRegistryError();
        for (EbXMLRegistryError error : errors) {
            RegistryError regError = ((EbXMLRegistryError30)error).getInternal();
            list.add(regError);
        }
    }

    @Override
    public void addReference(ObjectReference ref) {
        if (ref != null) {
            ObjectRefType objectRef = EbXMLFactory30.RIM_FACTORY.createObjectRefType();
            objectRef.setId(ref.getId());
            objectRef.setHome(ref.getHome());
            this.getContents().add(EbXMLFactory30.RIM_FACTORY.createObjectRef(objectRef));
        }
    }

    @Override
    public List<ObjectReference> getReferences() {
        ArrayList<ObjectReference> results = new ArrayList<ObjectReference>();
        for (JAXBElement<? extends IdentifiableType> identifiable : this.getContents()) {
            ObjectRefType objRefEbXML = this.cast(identifiable, ObjectRefType.class);
            if (objRefEbXML == null) continue;
            ObjectReference objRef = new ObjectReference();
            objRef.setId(objRefEbXML.getId());
            objRef.setHome(objRefEbXML.getHome());
            results.add(objRef);
        }
        return results;
    }

    @Override
    public AdhocQueryResponse getInternal() {
        return this.response;
    }
}

