/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlType(name="AssociationType")
@XmlEnum
public enum AssociationType {
    APPEND("APND", "urn:ihe:iti:2007:AssociationType:APND"),
    REPLACE("RPLC", "urn:ihe:iti:2007:AssociationType:RPLC"),
    TRANSFORM("XFRM", "urn:ihe:iti:2007:AssociationType:XFRM"),
    TRANSFORM_AND_REPLACE("XFRM_RPLC", "urn:ihe:iti:2007:AssociationType:XFRM_RPLC"),
    HAS_MEMBER("HasMember", "urn:oasis:names:tc:ebxml-regrep:AssociationType:HasMember"),
    SIGNS("signs", "urn:ihe:iti:2007:AssociationType:signs"),
    IS_SNAPSHOT_OF("IsSnapshotOf", "urn:ihe:iti:2010:AssociationType:IsSnapshotOf"),
    UPDATE_AVAILABILITY_STATUS("UpdateAvailabilityStatus", "urn:ihe:iti:2010:AssociationType:UpdateAvailabilityStatus"),
    SUBMIT_ASSOCIATION("SubmitAssociation", "urn:ihe:iti:2010:AssociationType:SubmitAssociation");

    private final String opcode21;
    private final String opcode30;

    private AssociationType(String opcode21, String opcode30) {
        this.opcode21 = opcode21;
        this.opcode30 = opcode30;
    }

    public String getOpcode21() {
        return this.opcode21;
    }

    public String getOpcode30() {
        return this.opcode30;
    }

    public static String getOpcode21(AssociationType type) {
        return type != null ? type.getOpcode21() : null;
    }

    public static String getOpcode30(AssociationType type) {
        return type != null ? type.getOpcode30() : null;
    }

    public static AssociationType valueOfOpcode21(String opcode) {
        if (opcode == null) {
            return null;
        }
        for (AssociationType type : AssociationType.values()) {
            if (!opcode.equals(type.getOpcode21())) continue;
            return type;
        }
        throw new XDSMetaDataException(ValidationMessage.INVALID_ASSOCIATION_TYPE, new Object[0]);
    }

    public static AssociationType valueOfOpcode30(String opcode) {
        if (opcode == null) {
            return null;
        }
        for (AssociationType type : AssociationType.values()) {
            if (!opcode.equals(type.getOpcode30())) continue;
            return type;
        }
        throw new XDSMetaDataException(ValidationMessage.INVALID_ASSOCIATION_TYPE, new Object[0]);
    }

    public boolean isReplace() {
        return this == REPLACE || this == TRANSFORM_AND_REPLACE;
    }
}

