/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlType(name="DocumentAvailability")
@XmlEnum
public enum DocumentAvailability {
    OFFLINE("Offline", "urn:ihe:iti:2010:DocumentAvailability:Offline"),
    ONLINE("Online", "urn:ihe:iti:2010:DocumentAvailability:Online");

    private final String opcode;
    private final String fullQualified;

    private DocumentAvailability(String opcode, String fullQualified) {
        this.opcode = opcode;
        this.fullQualified = fullQualified;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public String getFullQualified() {
        return this.fullQualified;
    }

    public static DocumentAvailability valueOfOpcode(String opcode) {
        if (opcode == null) {
            return null;
        }
        for (DocumentAvailability documentAvailability : DocumentAvailability.values()) {
            if (!opcode.equals(documentAvailability.getOpcode()) && !opcode.equals(documentAvailability.getFullQualified())) continue;
            return documentAvailability;
        }
        throw new XDSMetaDataException(ValidationMessage.INVALID_DOCUMENT_AVAILABILITY, opcode);
    }

    public static String toOpcode(DocumentAvailability documentAvailability) {
        return documentAvailability != null ? documentAvailability.getOpcode() : null;
    }

    public static String toFullQualifiedOpcode(DocumentAvailability status) {
        return status != null ? status.getFullQualified() : null;
    }
}

