/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import ca.uhn.hl7v2.model.v25.datatype.XTN;
import ca.uhn.hl7v2.parser.DefaultEscaping;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.CXiAssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ReferenceId;

public abstract class XdsHl7v2Renderer {
    public static final EncodingCharacters ENCODING_CHARACTERS = new EncodingCharacters('|', '^', '~', '\\', '&', '#');
    public static final Escaping ESCAPING = new DefaultEscaping();
    private static final Map<String, Collection<Integer>> INCLUSIONS = new HashMap<String, Collection<Integer>>();

    private static void addInclusion(Class<? extends Composite> hl7Class, Class<? extends Hl7v2Based> xdsClass, int ... fieldNumbers) {
        HashSet<Integer> collection = new HashSet<Integer>(fieldNumbers.length);
        for (int number : fieldNumbers) {
            collection.add(number - 1);
        }
        StringBuilder key = new StringBuilder(hl7Class.getSimpleName());
        if (xdsClass != null) {
            key.append('\n').append(xdsClass.getSimpleName());
        }
        INCLUSIONS.put(key.toString(), collection);
    }

    private XdsHl7v2Renderer() {
        throw new IllegalStateException("cannot instantiate helper class");
    }

    public static boolean isEmpty(Hl7v2Based hl7v2based) {
        try {
            return XdsHl7v2Renderer.isEmpty(hl7v2based.getHapiObject(), "\n" + hl7v2based.getClass().getSimpleName());
        }
        catch (HL7Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isEmpty(Composite composite, String keyModifier) throws HL7Exception {
        Type[] fields = composite.getComponents();
        String key = composite.getClass().getSimpleName();
        Collection<Integer> inclusions = INCLUSIONS.get(key);
        if (inclusions == null) {
            inclusions = INCLUSIONS.get(key + keyModifier);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (inclusions != null && !inclusions.contains(i)) continue;
            if (fields[i] instanceof Composite) {
                if (XdsHl7v2Renderer.isEmpty((Composite)fields[i], keyModifier)) continue;
                return false;
            }
            if (fields[i] instanceof Primitive) {
                if (fields[i].isEmpty()) continue;
                return false;
            }
            throw new IllegalStateException("Don't know how to handle " + fields[i]);
        }
        return true;
    }

    public static String encode(Hl7v2Based hl7v2based) {
        return XdsHl7v2Renderer.encodeComposite(hl7v2based.getHapiObject(), "\n" + hl7v2based.getClass().getSimpleName(), ENCODING_CHARACTERS.getComponentSeparator());
    }

    private static String encodeComposite(Composite composite, String keyModifier, char delimiter) {
        StringBuilder sb = new StringBuilder();
        Type[] fields = composite.getComponents();
        String key = composite.getClass().getSimpleName();
        Collection<Integer> inclusions = INCLUSIONS.get(key);
        if (inclusions == null) {
            inclusions = INCLUSIONS.get(key + keyModifier);
        }
        for (int i = 0; i < fields.length; ++i) {
            if (inclusions == null || inclusions.contains(i)) {
                if (fields[i] instanceof Composite) {
                    sb.append(XdsHl7v2Renderer.encodeComposite((Composite)fields[i], keyModifier, ENCODING_CHARACTERS.getSubcomponentSeparator()));
                } else if (fields[i] instanceof Primitive) {
                    sb.append(XdsHl7v2Renderer.encodePrimitive((Primitive)fields[i]));
                } else {
                    throw new IllegalStateException("Don't know how to handle " + fields[i]);
                }
            }
            sb.append(delimiter);
        }
        return StringUtils.stripEnd((String)sb.toString(), (String)String.valueOf(delimiter));
    }

    private static String encodePrimitive(Primitive p) {
        String value = p.getValue();
        return value == null ? "" : ESCAPING.escape(value, ENCODING_CHARACTERS);
    }

    static {
        XdsHl7v2Renderer.addInclusion(CE.class, null, 1, 3);
        XdsHl7v2Renderer.addInclusion(CX.class, Identifiable.class, 1, 4);
        XdsHl7v2Renderer.addInclusion(CX.class, ReferenceId.class, 1, 4, 5);
        XdsHl7v2Renderer.addInclusion(HD.class, AssigningAuthority.class, 2, 3);
        XdsHl7v2Renderer.addInclusion(HD.class, CXiAssigningAuthority.class, 1, 2, 3);
        XdsHl7v2Renderer.addInclusion(HD.class, Identifiable.class, 2, 3);
        XdsHl7v2Renderer.addInclusion(HD.class, ReferenceId.class, 1, 2, 3);
        XdsHl7v2Renderer.addInclusion(XON.class, null, 1, 6, 10);
        XdsHl7v2Renderer.addInclusion(XTN.class, null, 2, 3, 4, 5, 6, 7, 8, 12);
    }
}

