/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.responses;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang3.StringUtils;

@XmlType(name="ErrorCode")
@XmlEnum
public enum ErrorCode {
    MISSING_DOCUMENT("XDSMissingDocument"),
    MISSING_DOCUMENT_METADATA("XDSMissingDocumentMetadata"),
    REGISTRY_NOT_AVAILABLE("XDSRegistryNotAvailable"),
    REGISTRY_ERROR("XDSRegistryError"),
    REPOSITORY_ERROR("XDSRepositoryError"),
    REGISTRY_DUPLICATE_UNIQUE_ID_IN_MESSAGE("XDSRegistryDuplicateUniqueIdInMessage"),
    REPOSITORY_DUPLICATE_UNIQUE_ID_IN_MESSAGE("XDSRepositoryDuplicateUniqueIdInMessage"),
    DUPLICATE_UNIQUE_ID_IN_REGISTRY("XDSDuplicateUniqueIdInRegistry"),
    NON_IDENTICAL_HASH("XDSNonIdenticalHash"),
    NON_IDENTICAL_SIZE("XDSNonIdenticalSize"),
    REGISTRY_BUSY("XDSRegistryBusy"),
    REPOSITORY_BUSY("XDSRepositoryBusy"),
    REGISTRY_OUT_OF_RESOURCES("XDSRegistryOutOfResources"),
    REPOSITORY_OUT_OF_RESOURCES("XDSRepositoryOutOfResources"),
    REGISTRY_METADATA_ERROR("XDSRegistryMetadataError"),
    REPOSITORY_METADATA_ERROR("XDSRepositoryMetadataError"),
    TOO_MANY_RESULTS("XDSTooManyResults"),
    EXTRA_METADATA_NOT_SAVED("XDSExtraMetadataNotSaved"),
    UNKNOWN_PATIENT_ID("XDSUnknownPatientId"),
    PATIENT_ID_DOES_NOT_MATCH("XDSPatientIdDoesNotMatch"),
    UNKNOWN_STORED_QUERY("XDSUnknownStoredQuery"),
    STORED_QUERY_MISSING_PARAM("XDSStoredQueryMissingParam"),
    STORED_QUERY_PARAM_NUMBER("XDSStoredQueryParamNumber"),
    REGISTRY_DEPRECATED_DOCUMENT_ERROR("XDSRegistryDeprecatedDocumentError"),
    UNKNOWN_REPOSITORY_ID("XDSUnknownRepositoryId"),
    DOCUMENT_UNIQUE_ID_ERROR("XDSDocumentUniqueIdError"),
    RESULT_NOT_SINGLE_PATIENT("XDSResultNotSinglePatient"),
    PARTIAL_FOLDER_CONTENT_NOT_PROCESSED("PartialFolderContentNotProcessed"),
    PARTIAL_REPLACE_CONTENT_NOT_PROCESSED("PartialReplaceContentNotProcessed"),
    PARTIAL_TRANSFORM_NOT_PROCESSED("PartialTransformNotProcessed"),
    PARTIAL_APPEND_CONTENT_NOT_PROCESSED("PartialAppendContentNotProcessed"),
    PARTIAL_RELATIONSHIP_CONTENT_NOT_PROCESSED("PartialRelationshipContentNotProcessed"),
    PARTIAL_TRANSFORM_REPLACE_NOT_PROCESSED("PartialTransformReplaceNotProcessed"),
    DOCUMENT_QUEUED("DocumentQueued"),
    INVALID_DOCUMENT_CONTENT("InvalidDocumentContent"),
    UNKNOWN_COMMUNITY("XDSUnknownCommunity"),
    MISSING_HOME_COMMUNITY_ID("XDSMissingHomeCommunityId"),
    UNAVAILABLE_COMMUNITY("XDSUnavailableCommunity"),
    TRANSCODING_ERROR("TranscodingError"),
    METADATA_UPDATE_ERROR("XDSMetadataUpdateError"),
    PATIENT_ID_RECONCILIATION_ERROR("XDSPatientIDReconciliationError"),
    METADATA_UPDATE_OPERATION_ERROR("XDSMetadataUpdateOperationError"),
    METADATA_VERSION_ERROR("XDSMetadataVersionError"),
    REMOVE_DOCUMENTS_ERROR("XDSRemoveDocumentsError"),
    UNRESOLVED_REFERENCE_EXCEPTION("UnresolvedReferenceException"),
    REFERENCE_EXISTS_EXCEPTION("ReferencesExistException"),
    UNREFERENCED_OBJECT_EXCEPTION("XDSUnreferencedObjectException"),
    REPLACE_FAILED("XDSReplaceFailed"),
    OBJECT_TYPE_ERROR("XDSObjectTypeError"),
    METADATA_IDENTIFIER_ERROR("XDSMetadataIdentifierError"),
    INVALID_REQUEST_EXCEPTION("XDSInvalidRequestException"),
    UNMODIFIABLE_METADATA_ERROR("UnmodifiableMetadataError"),
    LOCAL_POLICY_RESTRICTION_ERROR("LocalPolicyRestrictionError"),
    METADATA_ANNOTATION_ERROR("XDSMetadataAnnotationError"),
    SQL_ERROR("XDSSqlError"),
    _USER_DEFINED("_UserDefined");

    private final String opcode;

    private ErrorCode(String opcode) {
        this.opcode = opcode;
    }

    public String getOpcode() {
        return this.opcode;
    }

    public static String getOpcode(ErrorCode errorCode) {
        return errorCode != null ? errorCode.getOpcode() : null;
    }

    public static ErrorCode valueOfOpcode(String opcode) {
        if (StringUtils.isBlank((CharSequence)opcode)) {
            return null;
        }
        for (ErrorCode code : ErrorCode.values()) {
            if (!opcode.equals(code.getOpcode())) continue;
            return code;
        }
        return _USER_DEFINED;
    }
}

