/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import ca.uhn.hl7v2.model.Composite;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom;

public class AuthorTransformer {
    private final EbXMLFactory factory;

    public AuthorTransformer(EbXMLFactory ebXMLFactory) {
        Validate.notNull((Object)ebXMLFactory, (String)"ebXMLFactory cannot be null", (Object[])new Object[0]);
        this.factory = ebXMLFactory;
    }

    public EbXMLClassification toEbXML(Author author, EbXMLObjectLibrary objectLibrary) {
        Validate.notNull((Object)objectLibrary, (String)"objectLibrary cannot be null", (Object[])new Object[0]);
        if (author == null) {
            return null;
        }
        EbXMLClassification classification = this.factory.createClassification(objectLibrary);
        classification.setNodeRepresentation("");
        String hl7XCN = Hl7v2Based.render(author.getAuthorPerson());
        if (hl7XCN != null) {
            classification.addSlot("authorPerson", hl7XCN);
        }
        AuthorTransformer.transformToHl7Slots(author.getAuthorInstitution(), classification, "authorInstitution");
        AuthorTransformer.transformToHl7Slots(author.getAuthorRole(), classification, "authorRole");
        AuthorTransformer.transformToHl7Slots(author.getAuthorSpecialty(), classification, "authorSpecialty");
        AuthorTransformer.transformToHl7Slots(author.getAuthorTelecom(), classification, "authorTelecommunication");
        return classification;
    }

    public Author fromEbXML(EbXMLClassification classification) {
        if (classification == null) {
            return null;
        }
        Author author = new Author();
        List<String> persons = classification.getSlotValues("authorPerson");
        if (persons.size() > 0) {
            Person person = Hl7v2Based.parse(persons.get(0), Person.class);
            author.setAuthorPerson(person);
        }
        AuthorTransformer.transformFromHl7Slots(classification, "authorInstitution", author.getAuthorInstitution(), Organization.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorRole", author.getAuthorRole(), Identifiable.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorSpecialty", author.getAuthorSpecialty(), Identifiable.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorTelecommunication", author.getAuthorTelecom(), Telecom.class);
        return author;
    }

    private static <C extends Composite, T extends Hl7v2Based<C>> void transformFromHl7Slots(EbXMLClassification sourceClassification, String sourceSlotName, List<T> targetCollection, Class<T> targetClass) {
        for (String source : sourceClassification.getSlotValues(sourceSlotName)) {
            T target = Hl7v2Based.parse(source, targetClass);
            if (target == null) continue;
            targetCollection.add(target);
        }
    }

    private static <T extends Hl7v2Based<?>> void transformToHl7Slots(List<T> sourceCollection, EbXMLClassification targetClassification, String targetSlotName) {
        ArrayList<String> targetCollection = new ArrayList<String>();
        for (Hl7v2Based source : sourceCollection) {
            String target = Hl7v2Based.render(source);
            if (source == null) continue;
            targetCollection.add(target);
        }
        String[] array = new String[targetCollection.size()];
        targetClassification.addSlot(targetSlotName, targetCollection.toArray(array));
    }
}

