/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;

public class CodeTransformer {
    private final EbXMLFactory factory;

    public CodeTransformer(EbXMLFactory ebXMLFactory) {
        Validate.notNull((Object)ebXMLFactory, (String)"ebXMLFactory cannot be null", (Object[])new Object[0]);
        this.factory = ebXMLFactory;
    }

    public EbXMLClassification toEbXML(Code code, EbXMLObjectLibrary objectLibrary) {
        if (code == null) {
            return null;
        }
        EbXMLClassification classification = this.factory.createClassification(objectLibrary);
        classification.setNodeRepresentation(code.getCode());
        classification.setName(code.getDisplayName());
        if (code.getSchemeName() != null) {
            classification.addSlot("codingScheme", code.getSchemeName());
        }
        return classification;
    }

    public Code fromEbXML(EbXMLClassification classification) {
        if (classification == null) {
            return null;
        }
        Code code = new Code();
        code.setCode(classification.getNodeRepresentation());
        code.setDisplayName(classification.getName());
        List<String> slotValues = classification.getSlotValues("codingScheme");
        if (slotValues.size() > 0) {
            code.setSchemeName(slotValues.get(0));
        }
        return code;
    }
}

