/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.List;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentAvailability;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ReferenceId;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.AuthorTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.CodeTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.XDSMetaClassTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.hl7.PatientInfoTransformer;

public class DocumentEntryTransformer
extends XDSMetaClassTransformer<EbXMLExtrinsicObject, DocumentEntry> {
    private final AuthorTransformer authorTransformer;
    private final CodeTransformer codeTransformer;
    private final PatientInfoTransformer patientInfoTransformer = new PatientInfoTransformer();

    public DocumentEntryTransformer(EbXMLFactory factory) {
        super("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", "XDSDocumentEntry.patientId", "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", "XDSDocumentEntry.uniqueId", "urn:uuid:ab9b591b-83ab-4d03-8f5d-f93b1fb92e85", factory);
        this.authorTransformer = new AuthorTransformer(factory);
        this.codeTransformer = new CodeTransformer(factory);
    }

    @Override
    protected EbXMLExtrinsicObject createEbXMLInstance(String id, EbXMLObjectLibrary objectLibrary) {
        return this.factory.createExtrinsic(id, objectLibrary);
    }

    @Override
    protected DocumentEntry createMetaClassInstance() {
        return new DocumentEntry();
    }

    @Override
    protected void addAttributesFromEbXML(DocumentEntry docEntry, EbXMLExtrinsicObject extrinsic) {
        super.addAttributesFromEbXML(docEntry, extrinsic);
        docEntry.setAvailabilityStatus(extrinsic.getStatus());
        docEntry.setMimeType(extrinsic.getMimeType());
        docEntry.setType(DocumentEntryType.valueOfUuid(extrinsic.getObjectType()));
        docEntry.setHomeCommunityId(extrinsic.getHome());
    }

    @Override
    protected void addAttributes(DocumentEntry metaData, EbXMLExtrinsicObject ebXML, EbXMLObjectLibrary objectLibrary) {
        super.addAttributes(metaData, ebXML, objectLibrary);
        ebXML.setStatus(metaData.getAvailabilityStatus());
        ebXML.setMimeType(metaData.getMimeType());
        ebXML.setObjectType(DocumentEntryType.toUuid(metaData.getType()));
        ebXML.setHome(metaData.getHomeCommunityId());
    }

    @Override
    protected void addSlotsFromEbXML(DocumentEntry docEntry, EbXMLExtrinsicObject extrinsic) {
        super.addSlotsFromEbXML(docEntry, extrinsic);
        docEntry.setCreationTime(extrinsic.getSingleSlotValue("creationTime"));
        docEntry.setHash(extrinsic.getSingleSlotValue("hash"));
        docEntry.setLanguageCode(extrinsic.getSingleSlotValue("languageCode"));
        docEntry.setServiceStartTime(extrinsic.getSingleSlotValue("serviceStartTime"));
        docEntry.setServiceStopTime(extrinsic.getSingleSlotValue("serviceStopTime"));
        docEntry.setRepositoryUniqueId(extrinsic.getSingleSlotValue("repositoryUniqueId"));
        docEntry.setUri(extrinsic.getSingleSlotValue("URI"));
        docEntry.setDocumentAvailability(DocumentAvailability.valueOfOpcode(extrinsic.getSingleSlotValue("documentAvailability")));
        String size = extrinsic.getSingleSlotValue("size");
        docEntry.setSize(size != null ? Long.valueOf(Long.parseLong(size)) : null);
        String hl7LegalAuthenticator = extrinsic.getSingleSlotValue("legalAuthenticator");
        docEntry.setLegalAuthenticator(Hl7v2Based.parse(hl7LegalAuthenticator, Person.class));
        String sourcePatient = extrinsic.getSingleSlotValue("sourcePatientId");
        docEntry.setSourcePatientId(Hl7v2Based.parse(sourcePatient, Identifiable.class));
        List<String> slotValues = extrinsic.getSlotValues("sourcePatientInfo");
        docEntry.setSourcePatientInfo(this.patientInfoTransformer.fromHL7(slotValues));
        for (String referenceIdValue : extrinsic.getSlotValues("urn:ihe:iti:xds:2013:referenceIdList")) {
            docEntry.getReferenceIdList().add(Hl7v2Based.parse(referenceIdValue, ReferenceId.class));
        }
    }

    @Override
    protected void addSlots(DocumentEntry docEntry, EbXMLExtrinsicObject extrinsic, EbXMLObjectLibrary objectLibrary) {
        super.addSlots(docEntry, extrinsic, objectLibrary);
        extrinsic.addSlot("creationTime", Timestamp.toHL7(docEntry.getCreationTime()));
        extrinsic.addSlot("hash", docEntry.getHash());
        extrinsic.addSlot("languageCode", docEntry.getLanguageCode());
        extrinsic.addSlot("serviceStartTime", Timestamp.toHL7(docEntry.getServiceStartTime()));
        extrinsic.addSlot("serviceStopTime", Timestamp.toHL7(docEntry.getServiceStopTime()));
        extrinsic.addSlot("repositoryUniqueId", docEntry.getRepositoryUniqueId());
        extrinsic.addSlot("URI", docEntry.getUri());
        extrinsic.addSlot("documentAvailability", DocumentAvailability.toFullQualifiedOpcode(docEntry.getDocumentAvailability()));
        Long size = docEntry.getSize();
        extrinsic.addSlot("size", size != null ? size.toString() : null);
        String hl7LegalAuthenticator = Hl7v2Based.render(docEntry.getLegalAuthenticator());
        extrinsic.addSlot("legalAuthenticator", hl7LegalAuthenticator);
        String sourcePatient = Hl7v2Based.render(docEntry.getSourcePatientId());
        extrinsic.addSlot("sourcePatientId", sourcePatient);
        List<String> slotValues = this.patientInfoTransformer.toHL7(docEntry.getSourcePatientInfo());
        extrinsic.addSlot("sourcePatientInfo", slotValues.toArray(new String[0]));
        if (!docEntry.getReferenceIdList().isEmpty()) {
            String[] referenceIdValues = new String[docEntry.getReferenceIdList().size()];
            for (int i = 0; i < docEntry.getReferenceIdList().size(); ++i) {
                referenceIdValues[i] = Hl7v2Based.render(docEntry.getReferenceIdList().get(i));
            }
            extrinsic.addSlot("urn:ihe:iti:xds:2013:referenceIdList", referenceIdValues);
        }
    }

    @Override
    protected void addClassificationsFromEbXML(DocumentEntry docEntry, EbXMLExtrinsicObject extrinsic) {
        super.addClassificationsFromEbXML(docEntry, extrinsic);
        for (EbXMLClassification author : extrinsic.getClassifications("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d")) {
            docEntry.getAuthors().add(this.authorTransformer.fromEbXML(author));
        }
        EbXMLClassification classCode = extrinsic.getSingleClassification("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a");
        docEntry.setClassCode(this.codeTransformer.fromEbXML(classCode));
        EbXMLClassification formatCode = extrinsic.getSingleClassification("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d");
        docEntry.setFormatCode(this.codeTransformer.fromEbXML(formatCode));
        EbXMLClassification healthcareFacility = extrinsic.getSingleClassification("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1");
        docEntry.setHealthcareFacilityTypeCode(this.codeTransformer.fromEbXML(healthcareFacility));
        EbXMLClassification practiceSetting = extrinsic.getSingleClassification("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead");
        docEntry.setPracticeSettingCode(this.codeTransformer.fromEbXML(practiceSetting));
        EbXMLClassification typeCode = extrinsic.getSingleClassification("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983");
        docEntry.setTypeCode(this.codeTransformer.fromEbXML(typeCode));
        List<Code> confidentialityCodes = docEntry.getConfidentialityCodes();
        confidentialityCodes.addAll(extrinsic.getClassifications("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f").stream().map(this.codeTransformer::fromEbXML).collect(Collectors.toList()));
        List<Code> eventCodeList = docEntry.getEventCodeList();
        eventCodeList.addAll(extrinsic.getClassifications("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4").stream().map(this.codeTransformer::fromEbXML).collect(Collectors.toList()));
    }

    @Override
    protected void addClassifications(DocumentEntry docEntry, EbXMLExtrinsicObject extrinsic, EbXMLObjectLibrary objectLibrary) {
        super.addClassifications(docEntry, extrinsic, objectLibrary);
        for (Author author : docEntry.getAuthors()) {
            EbXMLClassification authorClasification = this.authorTransformer.toEbXML(author, objectLibrary);
            extrinsic.addClassification(authorClasification, "urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d");
        }
        EbXMLClassification classCode = this.codeTransformer.toEbXML(docEntry.getClassCode(), objectLibrary);
        extrinsic.addClassification(classCode, "urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a");
        EbXMLClassification formatCode = this.codeTransformer.toEbXML(docEntry.getFormatCode(), objectLibrary);
        extrinsic.addClassification(formatCode, "urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d");
        EbXMLClassification healthcareFacility = this.codeTransformer.toEbXML(docEntry.getHealthcareFacilityTypeCode(), objectLibrary);
        extrinsic.addClassification(healthcareFacility, "urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1");
        EbXMLClassification practiceSetting = this.codeTransformer.toEbXML(docEntry.getPracticeSettingCode(), objectLibrary);
        extrinsic.addClassification(practiceSetting, "urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead");
        EbXMLClassification typeCode = this.codeTransformer.toEbXML(docEntry.getTypeCode(), objectLibrary);
        extrinsic.addClassification(typeCode, "urn:uuid:f0306f51-975f-434e-a61c-c59651d33983");
        for (Code confCode : docEntry.getConfidentialityCodes()) {
            EbXMLClassification conf = this.codeTransformer.toEbXML(confCode, objectLibrary);
            extrinsic.addClassification(conf, "urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f");
        }
        for (Code eventCode : docEntry.getEventCodeList()) {
            EbXMLClassification event = this.codeTransformer.toEbXML(eventCode, objectLibrary);
            extrinsic.addClassification(event, "urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4");
        }
    }
}

