/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Recipient;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom;

public class RecipientTransformer {
    public String toEbXML(Recipient recipient) {
        if (recipient == null) {
            return null;
        }
        String person = Hl7v2Based.render(recipient.getPerson());
        String organization = Hl7v2Based.render(recipient.getOrganization());
        String telecom = Hl7v2Based.render(recipient.getTelecom());
        if (person == null && organization == null && telecom == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (organization != null) {
            sb.append(organization);
        }
        if (person != null || telecom != null) {
            sb.append('|');
            if (person != null) {
                sb.append(person);
            }
            if (telecom != null) {
                sb.append('|').append(telecom);
            }
        }
        return sb.toString();
    }

    public Recipient fromEbXML(String slotValue) {
        if (slotValue == null || slotValue.isEmpty()) {
            return null;
        }
        Recipient recipient = new Recipient();
        String[] parts = slotValue.split("\\|");
        recipient.setOrganization(Hl7v2Based.parse(parts[0], Organization.class));
        if (parts.length > 1) {
            recipient.setPerson(Hl7v2Based.parse(parts[1], Person.class));
        }
        if (parts.length > 2) {
            recipient.setTelecom(Hl7v2Based.parse(parts[2], Telecom.class));
        }
        return recipient;
    }
}

