/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import java.util.Map;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.Query;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

abstract class AbstractStoredQueryTransformer<T extends StoredQuery> {
    AbstractStoredQueryTransformer() {
    }

    public void toEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ebXML.setId(((Query)query).getType().getId());
        ebXML.setHome(((StoredQuery)query).getHomeCommunityId());
        QuerySlotHelper slotHelper = new QuerySlotHelper(ebXML);
        for (Map.Entry<String, QueryList<String>> entry : ((StoredQuery)query).getExtraParameters().entrySet()) {
            slotHelper.fromStringList(entry.getKey(), entry.getValue());
        }
    }

    public void fromEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ((StoredQuery)query).setHomeCommunityId(ebXML.getHome());
        QuerySlotHelper slotHelper = new QuerySlotHelper(ebXML);
        for (EbXMLSlot slot : ebXML.getSlots()) {
            QueryList<String> queryList;
            String slotName = slot.getName();
            if (QueryParameter.valueOfSlotName(slotName) != null || ((StoredQuery)query).getExtraParameters().containsKey(slotName) || (queryList = slotHelper.toStringQueryList(slotName)) == null) continue;
            ((StoredQuery)query).getExtraParameters().put(slotName, queryList);
        }
    }
}

