/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.DocumentsQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindDocumentsQueryTransformer<T extends FindDocumentsQuery>
extends DocumentsQueryTransformer<T> {
    @Override
    public void toEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromString(QueryParameter.DOC_ENTRY_PATIENT_ID, Hl7v2Based.render(((FindDocumentsQuery)query).getPatientId()));
        slots.fromDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE, ((FindDocumentsQuery)query).getDocumentEntryTypes());
        slots.fromStatus(QueryParameter.DOC_ENTRY_STATUS, ((FindDocumentsQuery)query).getStatus());
        slots.fromDocumentAvailability(QueryParameter.DOC_ENTRY_DOCUMENT_AVAILABILITY, ((FindDocumentsQuery)query).getDocumentAvailability());
        slots.fromInteger(QueryParameter.METADATA_LEVEL, ((FindDocumentsQuery)query).getMetadataLevel());
    }

    @Override
    public void fromEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        String patientId = slots.toString(QueryParameter.DOC_ENTRY_PATIENT_ID);
        ((FindDocumentsQuery)query).setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        ((FindDocumentsQuery)query).setDocumentEntryTypes(slots.toDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE));
        ((FindDocumentsQuery)query).setStatus(slots.toStatus(QueryParameter.DOC_ENTRY_STATUS));
        ((FindDocumentsQuery)query).setDocumentAvailability(slots.toDocumentAvailability(QueryParameter.DOC_ENTRY_DOCUMENT_AVAILABILITY));
        ((FindDocumentsQuery)query).setMetadataLevel(slots.toInteger(QueryParameter.METADATA_LEVEL));
    }
}

