/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindFoldersForMultiplePatientsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindFoldersForMultiplePatientsQueryTransformer
extends AbstractStoredQueryTransformer<FindFoldersForMultiplePatientsQuery> {
    @Override
    public void toEbXML(FindFoldersForMultiplePatientsQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromPatientIdList(QueryParameter.FOLDER_PATIENT_ID, query.getPatientIds());
        slots.fromNumber(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM, Timestamp.toHL7(query.getLastUpdateTime().getFrom()));
        slots.fromNumber(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO, Timestamp.toHL7(query.getLastUpdateTime().getTo()));
        slots.fromCode(QueryParameter.FOLDER_CODES, query.getCodes());
        slots.fromStatus(QueryParameter.FOLDER_STATUS, query.getStatus());
    }

    @Override
    public void fromEbXML(FindFoldersForMultiplePatientsQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        query.setPatientIds(slots.toPatientIdList(QueryParameter.FOLDER_PATIENT_ID));
        query.setCodes(slots.toCodeQueryList(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME));
        query.getLastUpdateTime().setFrom(slots.toNumber(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM));
        query.getLastUpdateTime().setTo(slots.toNumber(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO));
        query.setStatus(slots.toStatus(QueryParameter.FOLDER_STATUS));
    }
}

