/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindMedicationListQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.PharmacyDocumentsQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindMedicationListQueryTransformer
extends PharmacyDocumentsQueryTransformer<FindMedicationListQuery> {
    @Override
    public void toEbXML(FindMedicationListQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromCode(QueryParameter.DOC_ENTRY_FORMAT_CODE, query.getFormatCodes());
        slots.fromDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE, query.getDocumentEntryTypes());
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_FROM, Timestamp.toHL7(query.getServiceStart().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TO, Timestamp.toHL7(query.getServiceStart().getTo()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_END_FROM, Timestamp.toHL7(query.getServiceEnd().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_END_TO, Timestamp.toHL7(query.getServiceEnd().getTo()));
    }

    @Override
    public void fromEbXML(FindMedicationListQuery query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        query.setFormatCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_FORMAT_CODE));
        query.setDocumentEntryTypes(slots.toDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE));
        query.getServiceStart().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_FROM));
        query.getServiceStart().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TO));
        query.getServiceEnd().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_END_FROM));
        query.getServiceEnd().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_END_TO));
    }
}

