/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.PharmacyStableDocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.PharmacyDocumentsQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

abstract class PharmacyStableDocumentsQueryTransformer<T extends PharmacyStableDocumentsQuery>
extends PharmacyDocumentsQueryTransformer<T> {
    PharmacyStableDocumentsQueryTransformer() {
    }

    @Override
    public void toEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.toEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        slots.fromStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, ((PharmacyStableDocumentsQuery)query).getAuthorPersons());
        slots.fromStringList(QueryParameter.DOC_ENTRY_UUID, ((PharmacyStableDocumentsQuery)query).getUuids());
        slots.fromStringList(QueryParameter.DOC_ENTRY_UNIQUE_ID, ((PharmacyStableDocumentsQuery)query).getUniqueIds());
        slots.fromNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getCreationTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getCreationTime().getTo()));
        slots.fromCode(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE, ((PharmacyStableDocumentsQuery)query).getHealthcareFacilityTypeCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE, ((PharmacyStableDocumentsQuery)query).getPracticeSettingCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_EVENT_CODE, ((PharmacyStableDocumentsQuery)query).getEventCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, ((PharmacyStableDocumentsQuery)query).getConfidentialityCodes());
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getServiceStartTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getServiceStartTime().getTo()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getServiceStopTime().getFrom()));
        slots.fromNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, Timestamp.toHL7(((PharmacyStableDocumentsQuery)query).getServiceStopTime().getTo()));
    }

    @Override
    public void fromEbXML(T query, EbXMLAdhocQueryRequest ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        super.fromEbXML(query, ebXML);
        QuerySlotHelper slots = new QuerySlotHelper(ebXML);
        ((PharmacyStableDocumentsQuery)query).setAuthorPersons(slots.toStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON));
        ((PharmacyStableDocumentsQuery)query).setConfidentialityCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE));
        ((PharmacyStableDocumentsQuery)query).getCreationTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM));
        ((PharmacyStableDocumentsQuery)query).getCreationTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_CREATION_TIME_TO));
        ((PharmacyStableDocumentsQuery)query).setEventCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_EVENT_CODE));
        ((PharmacyStableDocumentsQuery)query).setHealthcareFacilityTypeCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE));
        ((PharmacyStableDocumentsQuery)query).setPracticeSettingCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE));
        ((PharmacyStableDocumentsQuery)query).setUniqueIds(slots.toStringList(QueryParameter.DOC_ENTRY_UNIQUE_ID));
        ((PharmacyStableDocumentsQuery)query).setUuids(slots.toStringList(QueryParameter.DOC_ENTRY_UUID));
        ((PharmacyStableDocumentsQuery)query).getServiceStartTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM));
        ((PharmacyStableDocumentsQuery)query).getServiceStartTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO));
        ((PharmacyStableDocumentsQuery)query).getServiceStopTime().setFrom(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM));
        ((PharmacyStableDocumentsQuery)query).getServiceStopTime().setTo(slots.toNumber(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO));
    }
}

