/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;

public class ErrorInfoListTransformer {
    private final EbXMLFactory factory;

    public ErrorInfoListTransformer(EbXMLFactory factory) {
        Validate.notNull((Object)factory, (String)"ebXML factory must be not null", (Object[])new Object[0]);
        this.factory = factory;
    }

    public List<EbXMLRegistryError> toEbXML(List<ErrorInfo> errorInfoList) {
        Validate.notNull(errorInfoList, (String)"error info list cannot be null", (Object[])new Object[0]);
        return errorInfoList.stream().map(this::toEbXML).collect(Collectors.toList());
    }

    public List<ErrorInfo> fromEbXML(List<EbXMLRegistryError> registryErrorList) {
        Validate.notNull(registryErrorList, (String)"registry error list cannot be null", (Object[])new Object[0]);
        return registryErrorList.stream().map(this::fromEbXML).collect(Collectors.toList());
    }

    public EbXMLRegistryError toEbXML(ErrorInfo errorInfo) {
        Validate.notNull((Object)errorInfo, (String)"error info cannot be null", (Object[])new Object[0]);
        EbXMLRegistryError regError = this.factory.createRegistryError();
        regError.setErrorCode(errorInfo.getErrorCode() == ErrorCode._USER_DEFINED ? errorInfo.getCustomErrorCode() : ErrorCode.getOpcode(errorInfo.getErrorCode()));
        regError.setCodeContext(errorInfo.getCodeContext());
        regError.setSeverity(errorInfo.getSeverity());
        regError.setLocation(errorInfo.getLocation());
        return regError;
    }

    public ErrorInfo fromEbXML(EbXMLRegistryError ebXML) {
        ErrorInfo errorInfo = new ErrorInfo();
        ErrorCode errorCode = ErrorCode.valueOfOpcode(ebXML.getErrorCode());
        errorInfo.setErrorCode(errorCode);
        if (errorCode == ErrorCode._USER_DEFINED) {
            errorInfo.setCustomErrorCode(ebXML.getErrorCode());
        }
        errorInfo.setCodeContext(ebXML.getCodeContext());
        errorInfo.setLocation(ebXML.getLocation());
        errorInfo.setSeverity(ebXML.getSeverity());
        return errorInfo;
    }
}

