/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ReferenceId;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HL7ValidationUtils;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class CXiValidator
implements ValueValidator {
    @Override
    public void validate(String hl7CX) throws XDSMetaDataException {
        ReferenceId referenceId = Hl7v2Based.parse(hl7CX, ReferenceId.class);
        ValidatorAssertions.metaDataAssert(referenceId != null, ValidationMessage.CX_NEEDS_ID, new Object[0]);
        CX cx = (CX)referenceId.getHapiObject();
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx2_CheckDigit().getValue()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx3_CheckDigitScheme().getValue()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx6_AssigningFacility()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx7_EffectiveDate().getValue()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)cx.getCx8_ExpirationDate().getValue()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx9_AssigningJurisdiction()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(cx.getCx10_AssigningAgencyOrDepartment()), ValidationMessage.CXI_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)cx.getCx1_IDNumber().getValue()), ValidationMessage.CX_NEEDS_ID, hl7CX);
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)cx.getCx5_IdentifierTypeCode().getValue()), ValidationMessage.CXI_NEEDS_ID_TYPE_CODE, hl7CX);
        HD assigningAuthority = cx.getCx4_AssigningAuthority();
        if (!HL7ValidationUtils.isEmptyField(assigningAuthority)) {
            boolean cx41filled = StringUtils.isNotEmpty((CharSequence)assigningAuthority.getHd1_NamespaceID().getValue());
            boolean cx42filled = StringUtils.isNotEmpty((CharSequence)assigningAuthority.getHd2_UniversalID().getValue());
            boolean cx43filled = StringUtils.isNotEmpty((CharSequence)assigningAuthority.getHd3_UniversalIDType().getValue());
            ValidatorAssertions.metaDataAssert(cx41filled || cx42filled && cx43filled, ValidationMessage.CXI_INCOMPLETE_ASSIGNING_AUTHORITY, new Object[0]);
        }
    }
}

