/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.xds.CMPD;
import org.openehealth.ipf.commons.ihe.xds.XCA;
import org.openehealth.ipf.commons.ihe.xds.XCF;
import org.openehealth.ipf.commons.ihe.xds.XDS;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.CXValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.NopValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotLengthAndNameUniquenessValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.TimeValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.AssociationValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.ChoiceValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.CodeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.DocumentEntryTypeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.HomeCommunityIdValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.NumberValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryListCodeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StatusValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringListValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringValidation;

public class AdhocQueryRequestValidator
implements Validator<EbXMLAdhocQueryRequest, ValidationProfile> {
    private static final CXValidator cxValidator = new CXValidator(true);
    private static final TimeValidator timeValidator = new TimeValidator();
    private static final NopValidator nopValidator = new NopValidator();
    private static final Map<QueryType, Set<String>> ALLOWED_MULTIPLE_SLOTS = new EnumMap<QueryType, Set<String>>(QueryType.class);
    private static final Map<InteractionId, Set<QueryType>> ALLOWED_QUERY_TYPES;

    private static void addAllowedMultipleSlots(QueryType queryType, QueryParameter ... parameters) {
        Set slotNames = Arrays.stream(parameters).map(QueryParameter::getSlotName).collect(Collectors.toSet());
        ALLOWED_MULTIPLE_SLOTS.put(queryType, slotNames);
    }

    private QueryParameterValidation[] getValidators(QueryType queryType, ValidationProfile profile) {
        XdsIntegrationProfile.HomeCommunityIdOptionality homeCommunityIdOptionality = profile.getInteractionProfile().getHomeCommunityIdOptionality();
        switch (queryType) {
            case FETCH: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false), new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE, false), new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, timeValidator), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME), new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator), new HomeCommunityIdValidation(homeCommunityIdOptionality)};
            }
            case FIND_DOCUMENTS: 
            case FIND_DOCUMENTS_MPQ: {
                return new QueryParameterValidation[]{queryType.equals((Object)QueryType.FIND_DOCUMENTS) ? new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false) : new StringListValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator), new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, timeValidator), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME), new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator), new StatusValidation(QueryParameter.DOC_ENTRY_STATUS), new DocumentEntryTypeValidation()};
            }
            case FIND_DOCUMENTS_BY_REFERENCE_ID: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false), new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, timeValidator), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME), new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator), new StatusValidation(QueryParameter.DOC_ENTRY_STATUS), new DocumentEntryTypeValidation(), new StringListValidation(QueryParameter.DOC_ENTRY_REFERENCE_IDS, nopValidator)};
            }
            case FIND_SUBMISSION_SETS: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.SUBMISSION_SET_PATIENT_ID, cxValidator, false), new NumberValidation(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO, timeValidator), new StringValidation(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, nopValidator, true), new CodeValidation(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE), new StatusValidation(QueryParameter.SUBMISSION_SET_STATUS)};
            }
            case FIND_FOLDERS: 
            case FIND_FOLDERS_MPQ: {
                return new QueryParameterValidation[]{queryType.equals((Object)QueryType.FIND_FOLDERS) ? new StringValidation(QueryParameter.FOLDER_PATIENT_ID, cxValidator, false) : new StringListValidation(QueryParameter.FOLDER_PATIENT_ID, cxValidator), new NumberValidation(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO, timeValidator), new QueryListCodeValidation(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME), new StatusValidation(QueryParameter.FOLDER_STATUS)};
            }
            case GET_ALL: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.PATIENT_ID, cxValidator, false), new StatusValidation(QueryParameter.DOC_ENTRY_STATUS), new StatusValidation(QueryParameter.SUBMISSION_SET_STATUS), new StatusValidation(QueryParameter.FOLDER_STATUS), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME), new DocumentEntryTypeValidation()};
            }
            case GET_DOCUMENTS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID, QueryParameter.DOC_ENTRY_LOGICAL_ID), new StringListValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator), new StringListValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator)};
            }
            case GET_DOCUMENTS_AND_ASSOCIATIONS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID), new StringListValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator), new StringListValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator)};
            }
            case GET_FOLDERS_FOR_DOCUMENT: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID), new StringValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator, true), new StringValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator, true)};
            }
            case GET_FOLDERS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.FOLDER_UUID, QueryParameter.FOLDER_UNIQUE_ID, QueryParameter.FOLDER_LOGICAL_ID), new StringListValidation(QueryParameter.FOLDER_UUID, nopValidator), new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator)};
            }
            case GET_ASSOCIATIONS: 
            case GET_SUBMISSION_SETS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new StringListValidation(QueryParameter.UUID, nopValidator)};
            }
            case GET_SUBMISSION_SET_AND_CONTENTS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.SUBMISSION_SET_UUID, QueryParameter.SUBMISSION_SET_UNIQUE_ID), new StringValidation(QueryParameter.SUBMISSION_SET_UUID, nopValidator, true), new StringValidation(QueryParameter.SUBMISSION_SET_UNIQUE_ID, nopValidator, true), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME), new DocumentEntryTypeValidation()};
            }
            case GET_FOLDER_AND_CONTENTS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.FOLDER_UUID, QueryParameter.FOLDER_UNIQUE_ID), new StringValidation(QueryParameter.FOLDER_UUID, nopValidator, true), new StringValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator, true), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME), new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME), new DocumentEntryTypeValidation()};
            }
            case GET_RELATED_DOCUMENTS: {
                return new QueryParameterValidation[]{new HomeCommunityIdValidation(homeCommunityIdOptionality), new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID), new StringValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator, true), new StringValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator, true), new AssociationValidation(QueryParameter.ASSOCIATION_TYPE), new DocumentEntryTypeValidation()};
            }
            case FIND_MEDICATION_TREATMENT_PLANS: 
            case FIND_PRESCRIPTIONS: 
            case FIND_DISPENSES: 
            case FIND_MEDICATION_ADMINISTRATIONS: 
            case FIND_PRESCRIPTIONS_FOR_VALIDATION: 
            case FIND_PRESCRIPTIONS_FOR_DISPENSE: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false), new ChoiceValidation(true, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID), new StringListValidation(QueryParameter.FOLDER_UUID, nopValidator), new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator), new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, timeValidator), new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE), new CodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE), new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator), new StatusValidation(QueryParameter.DOC_ENTRY_STATUS)};
            }
            case FIND_MEDICATION_LIST: {
                return new QueryParameterValidation[]{new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TO, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_END_FROM, timeValidator), new NumberValidation(QueryParameter.DOC_ENTRY_SERVICE_END_TO, timeValidator), new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE), new StatusValidation(QueryParameter.DOC_ENTRY_STATUS), new DocumentEntryTypeValidation()};
            }
        }
        return null;
    }

    public void validate(EbXMLAdhocQueryRequest request, ValidationProfile profile) {
        Validate.notNull((Object)request, (String)"request cannot be null", (Object[])new Object[0]);
        if (profile == XCF.Interactions.ITI_63) {
            ValidatorAssertions.metaDataAssert(QueryReturnType.LEAF_CLASS_WITH_REPOSITORY_ITEM.getCode().equals(request.getReturnType()), ValidationMessage.UNKNOWN_RETURN_TYPE, request.getReturnType());
        } else {
            ValidatorAssertions.metaDataAssert(QueryReturnType.LEAF_CLASS.getCode().equals(request.getReturnType()) || QueryReturnType.OBJECT_REF.getCode().equals(request.getReturnType()), ValidationMessage.UNKNOWN_RETURN_TYPE, request.getReturnType());
        }
        QueryType queryType = QueryType.valueOfId(request.getId());
        ValidatorAssertions.metaDataAssert(queryType != null, ValidationMessage.UNKNOWN_QUERY_TYPE, request.getId());
        Set allowedQueryTypes = ALLOWED_QUERY_TYPES.getOrDefault(profile.getInteractionId(), Collections.emptySet());
        ValidatorAssertions.metaDataAssert(allowedQueryTypes.contains((Object)queryType), ValidationMessage.UNSUPPORTED_QUERY_TYPE, new Object[]{queryType});
        new SlotLengthAndNameUniquenessValidator().validateQuerySlots(request.getSlots(), ALLOWED_MULTIPLE_SLOTS.getOrDefault((Object)queryType, Collections.emptySet()));
        QueryParameterValidation[] validations = this.getValidators(queryType, profile);
        if (validations != null) {
            for (QueryParameterValidation validation : validations) {
                validation.validate(request);
            }
        }
        switch (queryType) {
            case FIND_DOCUMENTS_MPQ: {
                this.checkAtLeastOnePresent(request, QueryParameter.DOC_ENTRY_PATIENT_ID, QueryParameter.DOC_ENTRY_CLASS_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                break;
            }
            case FIND_FOLDERS_MPQ: {
                this.checkAtLeastOnePresent(request, QueryParameter.FOLDER_PATIENT_ID, QueryParameter.FOLDER_CODES);
            }
        }
    }

    private void checkAtLeastOnePresent(EbXMLAdhocQueryRequest request, QueryParameter ... params) {
        List slotNames = Arrays.stream(params).map(QueryParameter::getSlotName).collect(Collectors.toList());
        slotNames.stream().map(request::getSlotValues).filter(slotList -> !slotList.isEmpty()).findAny().orElseThrow(() -> new XDSMetaDataException(ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, "one of " + StringUtils.join((Iterable)slotNames, (String)", ")));
    }

    static {
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID, QueryParameter.DOC_ENTRY_REFERENCE_IDS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS_MPQ, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_FOLDERS, QueryParameter.FOLDER_CODES);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_FOLDERS_MPQ, QueryParameter.FOLDER_CODES);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_ALL, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_SUBMISSION_SET_AND_CONTENTS, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_FOLDER_AND_CONTENTS, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FETCH, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_MEDICATION_TREATMENT_PLANS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DISPENSES, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_MEDICATION_ADMINISTRATIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS_FOR_VALIDATION, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS_FOR_DISPENSE, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        EnumSet<QueryType[]> itiStoredQueryTypes = EnumSet.of(QueryType.FIND_DOCUMENTS, new QueryType[]{QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID, QueryType.FIND_SUBMISSION_SETS, QueryType.FIND_FOLDERS, QueryType.GET_ALL, QueryType.GET_DOCUMENTS, QueryType.GET_FOLDERS, QueryType.GET_ASSOCIATIONS, QueryType.GET_DOCUMENTS_AND_ASSOCIATIONS, QueryType.GET_SUBMISSION_SETS, QueryType.GET_SUBMISSION_SET_AND_CONTENTS, QueryType.GET_FOLDER_AND_CONTENTS, QueryType.GET_FOLDERS_FOR_DOCUMENT, QueryType.GET_RELATED_DOCUMENTS});
        EnumSet<QueryType[]> pharmStoredQueryTypes = EnumSet.of(QueryType.FIND_MEDICATION_TREATMENT_PLANS, new QueryType[]{QueryType.FIND_PRESCRIPTIONS, QueryType.FIND_DISPENSES, QueryType.FIND_MEDICATION_ADMINISTRATIONS, QueryType.FIND_PRESCRIPTIONS_FOR_VALIDATION, QueryType.FIND_PRESCRIPTIONS_FOR_DISPENSE, QueryType.FIND_MEDICATION_LIST});
        ALLOWED_QUERY_TYPES = new HashMap<InteractionId, Set<QueryType>>(5);
        ALLOWED_QUERY_TYPES.put((InteractionId)XDS.Interactions.ITI_18, itiStoredQueryTypes);
        ALLOWED_QUERY_TYPES.put((InteractionId)XCA.Interactions.ITI_38, itiStoredQueryTypes);
        ALLOWED_QUERY_TYPES.put((InteractionId)XDS.Interactions.ITI_51, EnumSet.of(QueryType.FIND_DOCUMENTS_MPQ, QueryType.FIND_FOLDERS_MPQ));
        ALLOWED_QUERY_TYPES.put((InteractionId)XCF.Interactions.ITI_63, EnumSet.of(QueryType.FETCH));
        ALLOWED_QUERY_TYPES.put((InteractionId)CMPD.Interactions.PHARM_1, pharmStoredQueryTypes);
    }
}

