/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.HashSet;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLProvideAndRegisterDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.requests.SubmitObjectsRequestValidator;

public class ProvideAndRegisterDocumentSetRequestValidator
implements Validator<EbXMLProvideAndRegisterDocumentSetRequest, ValidationProfile> {
    private final SubmitObjectsRequestValidator submitObjectsRequestValidator = new SubmitObjectsRequestValidator();

    public void validate(EbXMLProvideAndRegisterDocumentSetRequest request, ValidationProfile profile) {
        Validate.notNull((Object)request, (String)"request cannot be null", (Object[])new Object[0]);
        this.submitObjectsRequestValidator.validate(request, profile);
        this.validateDocuments(request);
    }

    private void validateDocuments(EbXMLProvideAndRegisterDocumentSetRequest request) {
        Map<String, DataHandler> documents = request.getDocuments();
        HashSet<String> docEntryIds = new HashSet<String>();
        for (EbXMLExtrinsicObject docEntry : request.getExtrinsicObjects(DocumentEntryType.STABLE.getUuid())) {
            String docId = docEntry.getId();
            if (docId == null) continue;
            docEntryIds.add(docId);
            ValidatorAssertions.metaDataAssert(documents.get(docId) != null, ValidationMessage.MISSING_DOCUMENT_FOR_DOC_ENTRY, docId);
        }
        for (String docId : documents.keySet()) {
            ValidatorAssertions.metaDataAssert(docEntryIds.contains(docId), ValidationMessage.MISSING_DOC_ENTRY_FOR_DOCUMENT, docId);
        }
    }
}

