/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.responses;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class RegistryResponseValidator
implements Validator<EbXMLRegistryResponse, ValidationProfile> {
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);

    public void validate(EbXMLRegistryResponse response, ValidationProfile profile) {
        Validate.notNull((Object)response, (String)"response cannot be null", (Object[])new Object[0]);
        ValidatorAssertions.metaDataAssert(response.getStatus() != null, ValidationMessage.INVALID_STATUS_IN_RESPONSE, new Object[0]);
        for (EbXMLRegistryError registryError : response.getErrors()) {
            ValidatorAssertions.metaDataAssert(registryError != null, ValidationMessage.INVALID_ERROR_INFO_IN_RESPONSE, new Object[0]);
            ValidatorAssertions.metaDataAssert(registryError.getErrorCode() != null, ValidationMessage.INVALID_ERROR_CODE_IN_RESPONSE, new Object[0]);
            ValidatorAssertions.metaDataAssert(registryError.getSeverity() != null, ValidationMessage.INVALID_SEVERITY_IN_RESPONSE, new Object[0]);
            if (profile.getInteractionProfile().getHomeCommunityIdOptionality() == XdsIntegrationProfile.HomeCommunityIdOptionality.NEVER) continue;
            this.hcValidator.validate(registryError.getLocation());
        }
    }
}

