/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.responses;

import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRetrieveDocumentSetResponse;
import org.openehealth.ipf.commons.ihe.xds.core.requests.DocumentReference;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocument;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.responses.RegistryResponseValidator;

public class RetrieveDocumentSetResponseValidator
implements Validator<EbXMLRetrieveDocumentSetResponse, ValidationProfile> {
    private final RegistryResponseValidator regResponseValidator = new RegistryResponseValidator();
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);

    public void validate(EbXMLRetrieveDocumentSetResponse response, ValidationProfile profile) {
        Validate.notNull((Object)response, (String)"response cannot be null", (Object[])new Object[0]);
        this.regResponseValidator.validate(response, profile);
        for (RetrievedDocument doc : response.getDocuments()) {
            DocumentReference requestData = doc.getRequestData();
            String repoId = requestData.getRepositoryUniqueId();
            ValidatorAssertions.metaDataAssert(repoId != null && !repoId.isEmpty(), ValidationMessage.REPO_ID_MUST_BE_SPECIFIED, new Object[0]);
            String docId = requestData.getDocumentUniqueId();
            ValidatorAssertions.metaDataAssert(docId != null && !docId.isEmpty(), ValidationMessage.DOC_ID_MUST_BE_SPECIFIED, new Object[0]);
            String newDocId = doc.getNewDocumentUniqueId();
            ValidatorAssertions.metaDataAssert(!docId.equals(newDocId), ValidationMessage.ON_DEMAND_DOC_ID_MUST_DIFFER, new Object[0]);
            String mimeType = doc.getMimeType();
            ValidatorAssertions.metaDataAssert(mimeType != null && !mimeType.isEmpty(), ValidationMessage.MIME_TYPE_MUST_BE_SPECIFIED, new Object[0]);
            if (profile.getInteractionProfile().getHomeCommunityIdOptionality() != XdsIntegrationProfile.HomeCommunityIdOptionality.NEVER) {
                this.hcValidator.validate(requestData.getHomeCommunityId());
            }
            ValidatorAssertions.metaDataAssert(doc.getDataHandler() != null, ValidationMessage.MISSING_DOCUMENT_FOR_DOC_ENTRY, docId);
        }
    }
}

