/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.util.ArrayList;
import javax.xml.transform.Source;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.xml.SchematronProfile;
import org.openehealth.ipf.commons.xml.SchematronTransmogrifier;
import org.openehealth.ipf.commons.xml.SchematronValidationException;
import org.openehealth.ipf.commons.xml.svrl.DiagnosticReference;
import org.openehealth.ipf.commons.xml.svrl.FailedAssert;
import org.openehealth.ipf.commons.xml.svrl.SchematronOutput;

public class SchematronValidator
implements Validator<Source, SchematronProfile> {
    private final SchematronTransmogrifier<SchematronOutput> schematronTransmogrifier = new SchematronTransmogrifier<SchematronOutput>(SchematronOutput.class);

    public void validate(Source message, SchematronProfile profile) {
        SchematronOutput svrl = (SchematronOutput)this.schematronTransmogrifier.zap(message, profile);
        ArrayList exceptions = new ArrayList();
        svrl.getActivePatternAndFiredRuleAndFailedAssert().stream().filter(o -> o instanceof FailedAssert).forEach(o -> {
            FailedAssert failedAssert = (FailedAssert)o;
            exceptions.add(new ValidationException(SchematronValidator.message(failedAssert)));
        });
        if (!exceptions.isEmpty()) {
            throw new SchematronValidationException(exceptions, svrl);
        }
    }

    private static String message(FailedAssert failedAssert) {
        StringBuilder sb = new StringBuilder().append("Validation error at ").append(failedAssert.getLocation()).append(" : ").append(failedAssert.getText());
        if (!failedAssert.getDiagnosticReference().isEmpty()) {
            sb.append("\nDetail:");
            for (DiagnosticReference diagnosticReference : failedAssert.getDiagnosticReference()) {
                sb.append('\n').append(diagnosticReference.getText());
            }
        }
        return sb.toString();
    }
}

