/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomainException;
import org.openhealthtools.ihe.atna.nodeauth.utils.AliasSensitiveX509KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDomain
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(SecurityDomain.class);
    public static final String JAVAX_NET_DEBUG = "javax.net.debug";
    public static final String JAVAX_NET_SSL_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_SSL_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String JAVAX_NET_SSL_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String HTTPS_CIPHERSUITES = "https.ciphersuites";
    public static final String HTTPS_PROTOCOLS = "https.protocols";
    private static final String[] ENVNAMES = new String[]{"javax.net.debug", "javax.net.ssl.keyStore", "javax.net.ssl.keyStorePassword", "javax.net.ssl.trustStore", "javax.net.ssl.trustStorePassword", "https.ciphersuites", "https.protocols"};
    private static final String[] SECURITY_STORE_FORMATS = new String[]{KeyStore.getDefaultType(), "jks", "pkcs12"};
    public static String TLS_RSA_WITH_AES_128_CBC_SHA = "TLS_RSA_WITH_AES_128_CBC_SHA";
    public static String TLS_RSA_WITH_NULL_SHA = "SSL_RSA_WITH_NULL_SHA";
    public static String DEFAULT_HTTPS_CIPHERSUITES = TLS_RSA_WITH_NULL_SHA + "," + TLS_RSA_WITH_AES_128_CBC_SHA;
    public static String DEFAULT_HTTPS_PROTOCOLS = "TLSv1";
    public static String DEFAULT_SECURITY_DOMAIN = "_DEFAULT_";
    private String name;
    KeyManagerFactory keyManagerFactory = null;
    KeyStore keyStore = null;
    TrustManagerFactory trustManagerFactory = null;
    KeyStore trustStore = null;
    private KeyManager[] keyManagers;
    String debug = null;
    String systemDebug = null;
    Properties domainProperties = null;
    Properties systemProperties = null;
    private boolean domainSpoofCheck = false;
    private String preferredKeyAlias;
    protected boolean keystoreInitialized = false;
    protected boolean truststoreInitialized = false;

    public SecurityDomain(String name, Properties properties) throws SecurityDomainException {
        this(name, null, properties);
    }

    public SecurityDomain(String name, String preferredAlias, Properties properties) throws SecurityDomainException {
        if (name == null || name.trim().length() < 1) {
            throw new IllegalArgumentException("SecurityDomain(String name, Properties properties) - name cannot be null or blank");
        }
        if (properties == null) {
            throw new IllegalArgumentException("SecurityDomain(String name, Properties properties) - properties cannot be null");
        }
        this.name = name;
        this.preferredKeyAlias = preferredAlias;
        if (logger.isDebugEnabled()) {
            logger.debug("Begin: Security name " + name + " setup.");
        }
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) throws SecurityDomainException {
        this.domainProperties = this.cloneProperites(properties);
        if (this.domainProperties.getProperty(HTTPS_CIPHERSUITES) == null) {
            this.domainProperties.setProperty(HTTPS_CIPHERSUITES, DEFAULT_HTTPS_CIPHERSUITES);
        }
        if (this.domainProperties.getProperty(HTTPS_PROTOCOLS) == null) {
            this.domainProperties.setProperty(HTTPS_PROTOCOLS, DEFAULT_HTTPS_PROTOCOLS);
        }
        this.initStores();
        if (logger.isDebugEnabled()) {
            logger.debug("Success: Security name " + this.name + " configured.");
        }
    }

    public void setDomainEnvironment() {
        if (logger.isDebugEnabled()) {
            logger.debug("Setting System environment properties to Security Domain values");
        }
        this.systemProperties = System.getProperties();
        for (int i = 0; i < ENVNAMES.length; ++i) {
            this.setOrClearSystemProperties(ENVNAMES[i], this.domainProperties);
        }
    }

    public void restoreSystemEnvironment() {
        if (this.systemProperties == null) {
            throw new NullPointerException("Must call SecurityDomain.setDomainEnvironment() first to record existing System environment");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Swapping back to original System environment properties values");
        }
        for (int i = 0; i < ENVNAMES.length; ++i) {
            this.setOrClearSystemProperties(ENVNAMES[i], this.systemProperties);
        }
    }

    private Properties cloneProperites(Properties source) {
        Properties clone = new Properties();
        for (int i = 0; i < ENVNAMES.length; ++i) {
            String v = source.getProperty(ENVNAMES[i]);
            if (v == null) continue;
            clone.setProperty(ENVNAMES[i], v);
        }
        return clone;
    }

    private void setOrClearSystemProperties(String name, Properties source) {
        String v = source.getProperty(name);
        if (v != null) {
            if (logger.isDebugEnabled()) {
                if (name.indexOf("assword") == -1) {
                    logger.debug("System property " + name + " set to " + v);
                } else {
                    logger.debug("System property " + name + " set to XXX (password not shown)");
                }
            }
            System.setProperty(name, v);
        } else {
            System.setProperty(name, "");
            if (logger.isDebugEnabled()) {
                logger.debug("System property " + name + " cleared.");
            }
        }
    }

    protected void initTrustStore(InputStream truststoreInputStream, char[] truststorePassword) throws SecurityDomainException, NoSuchAlgorithmException, CertificateException, IOException {
        if (null == truststoreInputStream) {
            this.truststoreInitialized = true;
            logger.warn("Truststore input stream is null.  Using JVM default trust store.");
            return;
        }
        for (int typeIndex = 0; typeIndex < SECURITY_STORE_FORMATS.length; ++typeIndex) {
            String storeType = SECURITY_STORE_FORMATS[typeIndex];
            try {
                truststoreInputStream.reset();
                this.trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                this.trustStore.load(truststoreInputStream, truststorePassword);
                this.trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                this.trustManagerFactory.init(this.trustStore);
                this.truststoreInitialized = true;
                if (!logger.isDebugEnabled()) break;
                logger.debug("Trust store for security domain " + this.name + " initialized successfully");
                break;
            }
            catch (KeyStoreException kse) {
                logger.warn("Unable to initialize trust store with type " + storeType, (Throwable)kse);
                continue;
            }
            catch (IOException ioe) {
                logger.warn("Error while loading truststore", (Throwable)ioe);
            }
        }
        if (!this.truststoreInitialized) {
            logger.error("Error initializing the trust manager. Trust store type cannot be loaded.");
            throw new SecurityDomainException("Error initializing the trust manager. Trust store type cannot be loaded.");
        }
    }

    protected void initKeyStore(InputStream keystoreInputStream, char[] keystorePassword) throws SecurityDomainException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, IOException {
        for (int typeIndex = 0; typeIndex < SECURITY_STORE_FORMATS.length; ++typeIndex) {
            String storeType = SECURITY_STORE_FORMATS[typeIndex];
            try {
                keystoreInputStream.reset();
                this.keyStore = KeyStore.getInstance(storeType);
                this.keyStore.load(keystoreInputStream, keystorePassword);
                this.keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                this.keyManagerFactory.init(this.keyStore, keystorePassword);
                this.fixKeyManagers();
                this.keystoreInitialized = true;
                if (!logger.isDebugEnabled()) break;
                logger.debug("Key store for security domain " + this.name + " initialized successfully");
                break;
            }
            catch (KeyStoreException kse) {
                logger.warn("Unable to initialize key store with type " + storeType, (Throwable)kse);
                continue;
            }
            catch (IOException ioe) {
                logger.warn("IO Error while loading keystore", (Throwable)ioe);
            }
        }
        if (!this.keystoreInitialized) {
            logger.error("Error initializing the key manager. Key store type cannot be loaded.");
            throw new SecurityDomainException("Error initializing the key manager. Key store type cannot be loaded.");
        }
    }

    protected void initStores() throws SecurityDomainException {
        this.setDomainEnvironment();
        char[] keyStorePasswd = this.domainProperties.getProperty(JAVAX_NET_SSL_KEYSTORE_PASSWORD, "").toCharArray();
        char[] trustStorePasswd = this.domainProperties.getProperty(JAVAX_NET_SSL_TRUSTSTORE_PASSWORD, "").toCharArray();
        String keyStoreName = this.domainProperties.getProperty(JAVAX_NET_SSL_KEYSTORE, null);
        if (logger.isDebugEnabled()) {
            logger.debug("Name of key store for security domain " + this.name + " is " + keyStoreName);
        }
        if (keyStoreName == null) {
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, "Key Store file is undefined");
        }
        String trustStoreName = this.domainProperties.getProperty(JAVAX_NET_SSL_TRUSTSTORE, null);
        if (logger.isDebugEnabled()) {
            if (trustStoreName != null) {
                logger.debug("Name of trust store for security domain " + this.name + " is " + trustStoreName);
            } else {
                logger.debug("Name of trust store for security domain " + this.name + " was not defined. Default trust store from JVM will be used");
            }
        }
        try {
            ByteArrayInputStream keystoreInputStream = SecurityDomain.preBufferInputStream(new FileInputStream(keyStoreName));
            this.initKeyStore(keystoreInputStream, keyStorePasswd);
            if (logger.isDebugEnabled()) {
                logger.debug("Key store for security domain " + this.name + " initialized successfully");
            }
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "Error: Key Store Manager Algorithm " + KeyManagerFactory.getDefaultAlgorithm() + " is not supported. " + e.getLocalizedMessage();
            logger.error(msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (CertificateException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error(msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (IOException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error(msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        catch (UnrecoverableKeyException e) {
            String msg = "Error loading key store file " + keyStoreName + ".  " + e.getLocalizedMessage();
            logger.error(msg);
            this.restoreSystemEnvironment();
            throw new SecurityDomainException(this.name, msg, e);
        }
        if (trustStoreName != null) {
            try {
                ByteArrayInputStream trustoreInputStream = SecurityDomain.preBufferInputStream(new FileInputStream(trustStoreName));
                this.initTrustStore(trustoreInputStream, trustStorePasswd);
                if (logger.isDebugEnabled()) {
                    logger.debug("Trust store for security domain " + this.name + " initialized successfully");
                }
            }
            catch (NoSuchAlgorithmException e) {
                String msg = "Error: Key Store Manager Algorithm " + KeyManagerFactory.getDefaultAlgorithm() + " is not supported. " + e.getLocalizedMessage();
                logger.error(msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
            catch (CertificateException e) {
                String msg = "Error loading trust store file " + trustStoreName + ".  " + e.getLocalizedMessage();
                logger.error(msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
            catch (IOException e) {
                String msg = "Error loading trust store file " + trustStoreName + ".  " + e.getLocalizedMessage();
                logger.error(msg);
                this.restoreSystemEnvironment();
                throw new SecurityDomainException(this.name, msg, e);
            }
        }
        this.restoreSystemEnvironment();
    }

    private void fixKeyManagers() {
        if (null == this.keyManagerFactory || null == this.keyManagerFactory.getKeyManagers()) {
            return;
        }
        KeyManager[] defaultKeyManagers = this.keyManagerFactory.getKeyManagers();
        KeyManager[] newKeyManagers = new KeyManager[defaultKeyManagers.length];
        KeyManager mgr = null;
        for (int i = 0; i < defaultKeyManagers.length; ++i) {
            mgr = defaultKeyManagers[i];
            if (mgr instanceof X509KeyManager) {
                mgr = new AliasSensitiveX509KeyManager(this, (X509KeyManager)mgr);
            }
            newKeyManagers[i] = mgr;
        }
        this.keyManagers = newKeyManagers;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public KeyManager[] getKeyManagers() {
        if (null == this.keyManagers) {
            return this.keyManagerFactory.getKeyManagers();
        }
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagerFactory.getTrustManagers();
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public String getName() {
        return this.name;
    }

    public String[] getCipherSuites() {
        String suitestring = this.domainProperties.getProperty(HTTPS_CIPHERSUITES);
        String[] suites = suitestring.split(",");
        return suites;
    }

    public String getPreferredKeyAlias() {
        return this.preferredKeyAlias;
    }

    public void setPreferredKeyAlias(String preferredKeyAlias, boolean validate) throws SecurityDomainException {
        if (validate) {
            boolean found = false;
            try {
                Enumeration<String> keystoreAliases = this.getKeyStore().aliases();
                while (keystoreAliases.hasMoreElements()) {
                    if (!preferredKeyAlias.equals(keystoreAliases.nextElement())) continue;
                    found = true;
                    break;
                }
            }
            catch (Exception e) {
                throw new SecurityDomainException(this.getName(), "Validation failed.  Unable to find the alias " + preferredKeyAlias + " in the Security Domain keystore.", e);
            }
            if (!found) {
                throw new SecurityDomainException(this.getName(), "Validation failed.  Unable to find the alias " + preferredKeyAlias + " in the Security Domain keystore.");
            }
        }
        this.preferredKeyAlias = preferredKeyAlias;
    }

    public boolean doDomainSpoofCheck() {
        return this.domainSpoofCheck;
    }

    public void setDomainSpoofCheck(boolean check) {
        this.domainSpoofCheck = check;
    }

    private static ByteArrayInputStream preBufferInputStream(InputStream in) throws IOException {
        int buf;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((buf = in.read()) != -1) {
            baos.write(buf);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public SecurityDomain clone() {
        SecurityDomain clone = null;
        try {
            clone = (SecurityDomain)super.clone();
            clone.fixKeyManagers();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clone;
    }

    public SecurityDomain clone(String newName) {
        SecurityDomain clone = this.clone();
        if (clone != null) {
            clone.name = newName;
        }
        return clone;
    }
}

