/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openhealthtools.ihe.atna.nodeauth.NoSecurityDomainException;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomain;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomainException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityDomainManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityDomainManager.class);
    private Map<String, SecurityDomain> securityDomains = Collections.synchronizedMap(new HashMap());
    private Map<String, String> uriToSecurityDomain = Collections.synchronizedMap(new HashMap());
    private boolean isDefaultSecurityDomainRegistered = false;

    public void registerSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomains.put(securityDomain.getName(), securityDomain);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security Domain " + securityDomain.getName() + " has been successfully registered to the configuration manager.");
        }
    }

    public void registerDefaultSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomains.put(SecurityDomain.DEFAULT_SECURITY_DOMAIN, securityDomain);
        this.registerSecurityDomain(securityDomain);
        this.isDefaultSecurityDomainRegistered = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security domain " + securityDomain.getName() + " has been successfully registered as the Default security domain.");
        }
    }

    public void registerURItoSecurityDomain(URI uri, String name) throws NoSecurityDomainException, URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("URI parameter cannot be null");
        }
        if (!this.securityDomains.containsKey(name)) {
            throw new IllegalArgumentException("Security domain " + name + " is not a configured security domain.");
        }
        if (this.uriToSecurityDomain.containsKey(uri)) {
            this.uriToSecurityDomain.remove(uri);
        }
        this.uriToSecurityDomain.put(this.formatKey(uri), name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security domain " + name + " has been registered for URI " + uri.toString());
        }
    }

    public void unregisterURItoSecurityDomain(URI uri) {
        try {
            this.uriToSecurityDomain.remove(this.formatKey(uri));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterDefaultSecurityDomain() {
        try {
            this.uriToSecurityDomain.remove(SecurityDomain.DEFAULT_SECURITY_DOMAIN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized SecurityDomain getSecurityDomain(String name) {
        return this.securityDomains.get(name);
    }

    public synchronized SecurityDomain getSecurityDomain(URI uri) throws NoSecurityDomainException, URISyntaxException {
        return this.getSecurityDomain(uri.getHost(), uri.getPort());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized SecurityDomain getSecurityDomain(String host, int port) throws NoSecurityDomainException, URISyntaxException {
        SecurityDomain domain;
        String name = this.uriToSecurityDomain.get(this.formatKey(host, port));
        if (name == null) {
            if (!this.isDefaultSecurityDomainRegistered) {
                this.registerDefaultSecurityDomain();
            }
            LOGGER.debug("No explicit Security Domain was registered for host " + host + " and port " + port);
            if (!this.securityDomains.containsKey(SecurityDomain.DEFAULT_SECURITY_DOMAIN)) throw new NoSecurityDomainException(null, "No DEFAULT Security Domain available for host " + host + " and port " + port);
            name = SecurityDomain.DEFAULT_SECURITY_DOMAIN;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Default Security Domain [" + name + "] has been found and will be used for host " + host + " and port " + port);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Security Domain [" + name + "] has been found and will be used for host " + host + " and port " + port);
        }
        if ((domain = this.securityDomains.get(name)) == null) {
            String msg = "Security Domain [" + name + "] was set for host " + host + " and port " + port + " but it could not be located in the set of registered domains.";
            LOGGER.error(msg);
            throw new NoSecurityDomainException(null, msg);
        }
        if (!LOGGER.isDebugEnabled()) return domain;
        LOGGER.debug("Security Domain [" + name + "] successfully retrieved.");
        return domain;
    }

    public Set<String> getRegisteredSecurityDomains() {
        return Collections.unmodifiableSet(this.securityDomains.keySet());
    }

    public String formatKey(URI uri) throws URISyntaxException {
        if (uri == null) {
            throw new URISyntaxException("", "URI specified is null");
        }
        return this.formatKey(uri.getHost(), uri.getPort());
    }

    public String formatKey(String host, int port) throws URISyntaxException {
        if (port < 1) {
            throw new URISyntaxException("", "The port value must be greater than zero");
        }
        if (!"".equals(host)) {
            return host + ":" + port;
        }
        throw new URISyntaxException("", "The host cannot be null");
    }

    private void registerDefaultSecurityDomain() {
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("KeyStore information has been detected in the system environment variables. Creating a default security domain with them.");
            }
            try {
                SecurityDomain domain = new SecurityDomain(SecurityDomain.DEFAULT_SECURITY_DOMAIN, System.getProperties());
                this.registerDefaultSecurityDomain(domain);
                this.isDefaultSecurityDomainRegistered = true;
            }
            catch (SecurityDomainException e) {
                LOGGER.error("Error initializing default keystore. No default SecurityDomain defined.", (Throwable)e);
            }
        } else {
            LOGGER.warn("No default security domain defined.");
        }
    }
}

