/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth.context;

import org.openhealthtools.ihe.atna.context.AbstractModuleConfig;
import org.openhealthtools.ihe.atna.nodeauth.context.ContextInitializer;

public class NodeAuthModuleConfig
extends AbstractModuleConfig {
    private static final long serialVersionUID = 1540226641819947849L;
    public static final String NODEAUTH_TLS_ENABLED_KEY = "nodeauth.tls.enabled";
    public static final String NODEAUTH_NON_TLS_CONNECTIONS_PERMITTED_KEY = "nodeauth.nontls.permitted";
    public static final String NODEAUTH_SOCKET_RETRIES_KEY = "nodeauth.socket.retries";
    public static final String NODEAUTH_SOCKET_RETRY_WAIT_KEY = "nodeauth.socket.retry.wait";
    public static final String NODEAUTH_SOCKET_TIMEOUT_KEY = "nodeauth.socket.timeout";
    public static final String NODEAUTH_CONNECT_TIMEOUT_KEY = "nodeauth.connect.timeout";

    public NodeAuthModuleConfig() {
        this.setTLSEnabled(true);
        this.setNonTLSConnectionsPermitted(true);
        this.setSocketRetries(ContextInitializer.DEFAULT_SOCKET_RETRIES);
        this.setSocketRetryWait(ContextInitializer.DEFAULT_SOCKET_RETRY_WAIT);
        this.setSocketTimeout(ContextInitializer.DEFAULT_SOCKET_TIMEOUT);
        this.setConnectTimeout(ContextInitializer.DEFAULT_CONNECT_TIMEOUT);
    }

    public boolean isTLSEnabled() {
        return Boolean.valueOf(this.getOption(NODEAUTH_TLS_ENABLED_KEY));
    }

    public void setTLSEnabled(boolean enable) {
        this.setOption(NODEAUTH_TLS_ENABLED_KEY, Boolean.toString(enable));
    }

    public boolean isNonTLSConnectionsPermitted() {
        return Boolean.valueOf(this.getOption(NODEAUTH_NON_TLS_CONNECTIONS_PERMITTED_KEY));
    }

    public void setNonTLSConnectionsPermitted(boolean enable) {
        this.setOption(NODEAUTH_NON_TLS_CONNECTIONS_PERMITTED_KEY, Boolean.toString(enable));
    }

    public int getSocketRetries() {
        return Integer.valueOf(this.getOption(NODEAUTH_SOCKET_RETRIES_KEY));
    }

    public void setSocketRetries(int count) {
        this.setOption(NODEAUTH_SOCKET_RETRIES_KEY, Integer.toString(count));
    }

    public int getSocketRetryWait() {
        return Integer.valueOf(this.getOption(NODEAUTH_SOCKET_RETRY_WAIT_KEY));
    }

    public void setSocketRetryWait(int ms) {
        this.setOption(NODEAUTH_SOCKET_RETRY_WAIT_KEY, Integer.toString(ms));
    }

    public int getSocketTimeout() {
        return Integer.valueOf(this.getOption(NODEAUTH_SOCKET_TIMEOUT_KEY));
    }

    public void setSocketTimeout(int ms) {
        this.setOption(NODEAUTH_SOCKET_TIMEOUT_KEY, Integer.toString(ms));
    }

    public int getConnectTimeout() {
        return Integer.valueOf(this.getOption(NODEAUTH_CONNECT_TIMEOUT_KEY));
    }

    public void setConnectTimeout(int ms) {
        this.setOption(NODEAUTH_CONNECT_TIMEOUT_KEY, Integer.toString(ms));
    }
}

