/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth.context;

import org.openhealthtools.ihe.atna.context.AbstractModuleConfig;
import org.openhealthtools.ihe.atna.context.AbstractModuleContext;
import org.openhealthtools.ihe.atna.context.SecurityContext;
import org.openhealthtools.ihe.atna.context.SecurityContextFactory;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomainManager;
import org.openhealthtools.ihe.atna.nodeauth.SocketHandler;
import org.openhealthtools.ihe.atna.nodeauth.context.ContextInitializer;
import org.openhealthtools.ihe.atna.nodeauth.context.NodeAuthModuleConfig;
import org.openhealthtools.ihe.atna.nodeauth.handlers.TLSEnabledSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeAuthModuleContext
extends AbstractModuleContext {
    private static final long serialVersionUID = 1416678175002183697L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeAuthModuleContext.class);
    private static final String CONTEXT_ID = "org.openhealthtools.ihe.atna.nodeauth";
    private SocketHandler socketHandler;
    private SecurityDomainManager domainManager = new SecurityDomainManager();

    public static NodeAuthModuleContext getContext() {
        AbstractModuleContext moduleContext;
        SecurityContext securityContext = SecurityContextFactory.getSecurityContext();
        if (!securityContext.isInitialized()) {
            securityContext.initialize();
        }
        if (!((moduleContext = securityContext.getModuleContext(CONTEXT_ID)) instanceof NodeAuthModuleContext)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing the NodeAuthModuleContext");
            }
            moduleContext = ContextInitializer.defaultInitialize();
            securityContext.registerModuleContext(CONTEXT_ID, moduleContext);
        }
        return (NodeAuthModuleContext)moduleContext;
    }

    protected NodeAuthModuleContext() {
        super((AbstractModuleConfig)new NodeAuthModuleConfig());
        this.socketHandler = new TLSEnabledSocketHandler(this);
    }

    public NodeAuthModuleConfig getConfig() {
        return (NodeAuthModuleConfig)this.config;
    }

    public String getContextId() {
        return CONTEXT_ID;
    }

    public final SocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public final SecurityDomainManager getSecurityDomainManager() {
        return this.domainManager;
    }

    public void setTLSEnabled(boolean enableTLS) {
        this.getConfig().setTLSEnabled(enableTLS);
    }

    public boolean isTLSEnabled() {
        return this.getConfig().isTLSEnabled();
    }

    public void setNonTLSConnectionsPermitted(boolean enableNonTLS) {
        this.getConfig().setNonTLSConnectionsPermitted(enableNonTLS);
    }

    public boolean isNonTLSConnectionsPermitted() {
        return this.getConfig().isNonTLSConnectionsPermitted();
    }
}

