/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth.handlers;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import org.openhealthtools.ihe.atna.nodeauth.NoSecurityDomainException;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomain;
import org.openhealthtools.ihe.atna.nodeauth.SocketHandler;
import org.openhealthtools.ihe.atna.nodeauth.context.NodeAuthModuleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecureSocketHandler
implements SocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecureSocketHandler.class);
    protected final NodeAuthModuleContext CONTEXT;

    public AbstractSecureSocketHandler(NodeAuthModuleContext context) {
        this.CONTEXT = context;
    }

    protected abstract Socket createSecureSocket(String var1, int var2, SecurityDomain var3, Socket var4) throws Exception;

    @Override
    public Socket getSocket(URI uri, boolean wantTLS) throws Exception {
        if (uri == null) {
            throw new URISyntaxException("", "The URI specified cannot be null");
        }
        SecurityDomain securityDomain = null;
        if (wantTLS) {
            securityDomain = this.CONTEXT.getSecurityDomainManager().getSecurityDomain(uri);
        }
        return this.getSocket(uri, wantTLS, securityDomain);
    }

    @Override
    public Socket getSocket(URI uri, boolean wantTLS, SecurityDomain securityDomain) throws Exception {
        if (uri == null) {
            throw new URISyntaxException("", "The URI specified cannot be null");
        }
        String host = uri.getHost();
        int port = uri.getPort();
        if (!"".equals(host) && port > 0) {
            return this.getSocket(host, port, wantTLS, securityDomain);
        }
        throw new URISyntaxException(uri.toString(), "Invalid host or port specified.  Host cannot be empty and port must be defined and greater than zero");
    }

    @Override
    public Socket getSocket(String host, int port, boolean useSecureSocket) throws Exception {
        SecurityDomain securityDomain = null;
        if (useSecureSocket) {
            securityDomain = this.CONTEXT.getSecurityDomainManager().getSecurityDomain(host, port);
        }
        return this.getSocket(host, port, useSecureSocket, securityDomain);
    }

    @Override
    public Socket getSocket(String host, int port, boolean useSecureSocket, SecurityDomain securityDomain) throws Exception {
        return this.getSocket(host, port, useSecureSocket, securityDomain, null);
    }

    @Override
    public Socket getSocket(String host, int port, boolean useSecureSocket, SecurityDomain securityDomain, Socket socketWrapper) throws Exception {
        if (!this.CONTEXT.isTLSEnabled() && !this.CONTEXT.isNonTLSConnectionsPermitted()) {
            throw new NoSuchAlgorithmException("TLS has been disabled for ATNA connections via " + NodeAuthModuleContext.class.getName() + ".setTLSEnabled(false)");
        }
        boolean useTLS = useSecureSocket && this.CONTEXT.isTLSEnabled() || !this.CONTEXT.isNonTLSConnectionsPermitted();
        Socket socket = null;
        if (useTLS) {
            if (null == securityDomain) {
                throw new NoSecurityDomainException("TLS was requested but no Security Domain provided for the host " + host + " on port " + port);
            }
            socket = this.createSecureSocket(host, port, securityDomain, socketWrapper);
            if (useTLS) {
                logger.info("Connection succesfully made using TLS to host " + host + " on port " + port);
            }
        } else {
            socket = this.createSocket(host, port);
        }
        return socket;
    }

    protected Socket createSocket(String host, int port) throws SocketException, UnknownHostException {
        Socket socket = null;
        int retries = 0;
        Throwable cause = null;
        while (retries < this.CONTEXT.getConfig().getSocketRetries()) {
            try {
                socket = this.createSocketFromFactory(SocketFactory.getDefault(), host, port);
                break;
            }
            catch (UnknownHostException e) {
                logger.error("Unknown host. Unable to establish connection to " + host + " on port " + port + ". Reason: " + e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            catch (SocketException e) {
                logger.error("Error connecting to " + host + " on port " + port + ". Will retry in " + this.CONTEXT.getConfig().getSocketRetryWait() / 1000 + " seconds. " + (this.CONTEXT.getConfig().getSocketRetries() - retries) + " retries left. Cause: " + e.getLocalizedMessage(), (Throwable)e);
                cause = e;
                ++retries;
                try {
                    Thread.sleep(this.CONTEXT.getConfig().getSocketRetryWait());
                }
                catch (InterruptedException ie) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Sleep awoken early");
                }
            }
            catch (IOException e) {
                logger.error("Error connecting to " + host + " on port " + port + ". Will retry in " + this.CONTEXT.getConfig().getSocketRetryWait() / 1000 + " seconds. " + (this.CONTEXT.getConfig().getSocketRetries() - retries) + " retries left. Cause: " + e.getLocalizedMessage(), (Throwable)e);
                ++retries;
                cause = e;
            }
        }
        if (retries >= this.CONTEXT.getConfig().getSocketRetries()) {
            logger.error("Socket Connect Retries Exhausted.", cause);
            throw new ConnectException("Socket Connect Retries Exhausted. " + (cause != null ? "Cause was: " + cause.getLocalizedMessage() : ""));
        }
        return socket;
    }

    protected Socket createSocketFromFactory(SocketFactory factory, String host, int port) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Connecting to " + host + " on port " + port + " (timeout: " + this.CONTEXT.getConfig().getConnectTimeout() + " ms) using factory " + factory.getClass().getName());
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        Socket socket = factory.createSocket();
        socket.connect(address, this.CONTEXT.getConfig().getConnectTimeout());
        socket.setSoTimeout(this.CONTEXT.getConfig().getSocketTimeout());
        socket.setKeepAlive(true);
        return socket;
    }
}

