/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.openhealthtools.ihe.atna.nodeauth.NoSecurityDomainException;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomain;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomainManager;
import org.openhealthtools.ihe.atna.nodeauth.context.NodeAuthModuleContext;
import org.openhealthtools.ihe.atna.nodeauth.handlers.AbstractSecureSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSEnabledSocketHandler
extends AbstractSecureSocketHandler {
    private static final Logger logger = LoggerFactory.getLogger(TLSEnabledSocketHandler.class);

    public TLSEnabledSocketHandler(NodeAuthModuleContext context) {
        super(context);
    }

    @Override
    protected SSLSocket createSecureSocket(String host, int port, SecurityDomain securityDomain, Socket nestedSocket) throws NoSecurityDomainException, NoSuchAlgorithmException, KeyManagementException, UnknownHostException, IOException {
        if (!this.CONTEXT.isTLSEnabled()) {
            throw new NoSuchAlgorithmException("TLS has been disabled for ATNA connections via " + SecurityDomainManager.class.getName() + ".setSetTLSEnabled(false)");
        }
        SSLContext ctx = null;
        try {
            ctx = SSLContext.getInstance("TLSv1");
        }
        catch (NoSuchAlgorithmException e) {
            securityDomain.restoreSystemEnvironment();
            throw e;
        }
        KeyManager[] keyMgrs = securityDomain.getKeyManagers();
        TrustManager[] trustMgrs = securityDomain.getTrustManagers();
        ctx.init(keyMgrs, trustMgrs, null);
        SSLSocketFactory factory = ctx.getSocketFactory();
        SSLSocket socket = null;
        if (logger.isDebugEnabled()) {
            String[] supportedSuites = factory.getSupportedCipherSuites();
            logger.debug("\n\nSupported ciper suites are:");
            for (int i = 0; i < supportedSuites.length; ++i) {
                logger.debug("\t" + supportedSuites[i]);
            }
        }
        int retries = 0;
        IOException cause = null;
        while (retries < this.CONTEXT.getConfig().getSocketRetries()) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Connecting to " + host + " on port " + port + " (timeout: " + this.CONTEXT.getConfig().getConnectTimeout() + " ms) using factory " + factory.getClass().getName());
                }
                socket = nestedSocket instanceof Socket ? (SSLSocket)factory.createSocket(nestedSocket, host, port, true) : (SSLSocket)factory.createSocket(host, port);
                socket.setSoTimeout(this.CONTEXT.getConfig().getSocketTimeout());
                socket.setKeepAlive(true);
                socket.setEnabledProtocols(new String[]{"TLSv1"});
                socket.setEnabledCipherSuites(securityDomain.getCipherSuites());
                if (logger.isDebugEnabled()) {
                    logger.debug("\n\nEnabled Cipher suites for connection are: ");
                    String[] suites = socket.getEnabledCipherSuites();
                    for (int i = 0; i < suites.length; ++i) {
                        logger.debug("\t" + suites[i]);
                    }
                }
                socket.startHandshake();
                break;
            }
            catch (SSLHandshakeException e) {
                logger.error("Handshake failed with server " + host + " on port " + port + " reason " + e.getLocalizedMessage(), (Throwable)e);
                try {
                    socket.close();
                }
                catch (IOException e1) {
                    logger.error("Error trying to close socket for " + host + " on port " + port + " reason " + e1.getLocalizedMessage(), (Throwable)e1);
                }
                throw e;
            }
            catch (UnknownHostException e) {
                logger.error("Unable to establish connection to " + host + " on port " + port + " reason " + e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
            catch (SocketException e) {
                logger.error("Error connecting to " + host + " on port " + port + ". Will retry in " + this.CONTEXT.getConfig().getSocketRetryWait() / 1000 + " seconds.", (Throwable)e);
                ++retries;
                cause = e;
                try {
                    Thread.sleep(this.CONTEXT.getConfig().getSocketRetryWait());
                }
                catch (InterruptedException ie) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Sleep awoken early");
                }
            }
            catch (IOException e) {
                logger.error("Error connecting to " + host + " on port " + port + ". Will retry in " + this.CONTEXT.getConfig().getSocketRetryWait() / 1000 + " seconds." + " reason " + e.getLocalizedMessage(), (Throwable)e);
                ++retries;
                cause = e;
                try {
                    Thread.sleep(this.CONTEXT.getConfig().getSocketRetryWait());
                }
                catch (InterruptedException ie) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Sleep awoken early");
                }
            }
        }
        if (retries >= this.CONTEXT.getConfig().getSocketRetries()) {
            logger.error("Secure Socket Connect Retries Exhausted.", cause);
            throw new ConnectException("Secure socket retries exhausted");
        }
        return socket;
    }

    @Override
    public InputStream getInputStream(URI uri, SecurityDomain securityDomain) throws NoSecurityDomainException, MalformedURLException, IOException, NoSuchAlgorithmException {
        boolean useTLS;
        NodeAuthModuleContext context = NodeAuthModuleContext.getContext();
        if (!context.isTLSEnabled() && !context.isNonTLSConnectionsPermitted()) {
            throw new NoSuchAlgorithmException("TLS has been disabled for ATNA connections");
        }
        boolean tlsURI = uri.getScheme().equalsIgnoreCase("https");
        boolean bl = useTLS = tlsURI && context.isTLSEnabled() || !context.isNonTLSConnectionsPermitted();
        if (useTLS && null == securityDomain) {
            throw new NoSecurityDomainException(uri, "Security domain provided is null");
        }
        if (useTLS) {
            securityDomain.setDomainEnvironment();
        }
        InputStream is = null;
        try {
            URLConnection connection = uri.toURL().openConnection();
            if (useTLS && !securityDomain.doDomainSpoofCheck()) {
                ((HttpsURLConnection)connection).setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String urlHostName, SSLSession session) {
                        return true;
                    }
                });
            }
            is = connection.getInputStream();
            if (useTLS) {
                logger.info("Secure connection succesfully made using TLS to " + uri.toString());
            } else {
                logger.info("Unsecure connection succesfully made to " + uri.toString());
            }
        }
        catch (MalformedURLException e) {
            if (useTLS) {
                securityDomain.restoreSystemEnvironment();
            }
            throw e;
        }
        catch (IOException e) {
            if (useTLS) {
                securityDomain.restoreSystemEnvironment();
            }
            throw e;
        }
        if (useTLS) {
            securityDomain.restoreSystemEnvironment();
        }
        return is;
    }

    @Override
    public InputStream getInputStream(URI uri) throws Exception {
        boolean tlsURI = uri.getScheme().equalsIgnoreCase("https");
        SecurityDomain securityDomain = null;
        if (tlsURI) {
            NodeAuthModuleContext context = NodeAuthModuleContext.getContext();
            securityDomain = context.getSecurityDomainManager().getSecurityDomain(uri);
        }
        return this.getInputStream(uri, securityDomain);
    }
}

