/*
 * Decompiled with CFR 0.152.
 */
package org.openhealthtools.ihe.atna.nodeauth.utils;

import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.openhealthtools.ihe.atna.nodeauth.SecurityDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasSensitiveX509KeyManager
implements X509KeyManager {
    public static final Logger LOGGER = LoggerFactory.getLogger(AliasSensitiveX509KeyManager.class);
    private SecurityDomain domain;
    private X509KeyManager parent;

    public AliasSensitiveX509KeyManager(SecurityDomain domain, X509KeyManager parent) {
        this.parent = parent;
        this.domain = domain;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        if (null == this.domain || this.domain.getPreferredKeyAlias() == null) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("No preferred key alias defined.  Defaulting to JSSE certificate selection.");
            }
            return this.parent.chooseClientAlias(keyType, issuers, socket);
        }
        String preferredAlias = this.domain.getPreferredKeyAlias();
        String alias = null;
        if (keyType != null && keyType.length > 0) {
            for (int i = 0; i < keyType.length; ++i) {
                alias = this.chooseClientAliasForKey(preferredAlias, keyType[i], issuers, socket);
                if (alias == null || "".equals(alias)) continue;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Found valid keystore alias: " + alias);
                }
                return alias;
            }
        }
        LOGGER.warn("The requested key alias " + preferredAlias + " was not found in the keystore.  No certificate selected.  The transaction will probably fail.");
        return null;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.parent.chooseServerAlias(keyType, issuers, socket);
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.parent.getCertificateChain(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.parent.getClientAliases(keyType, issuers);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.parent.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.parent.getServerAliases(keyType, issuers);
    }

    private String chooseClientAliasForKey(String preferredAlias, String keyType, Principal[] issuers, Socket socket) {
        String[] aliases = this.getClientAliases(keyType, issuers);
        if (aliases != null && aliases.length > 0) {
            for (int i = 0; i < aliases.length; ++i) {
                if (!preferredAlias.equals(aliases[i])) continue;
                return aliases[i];
            }
        }
        return null;
    }
}

