/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Act Class</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getActClass()
 * @model
 * @generated
 */
public enum ActClass implements Enumerator {
	/**
	 * The '<em><b>ACCM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACCM_VALUE
	 * @generated
	 * @ordered
	 */
	ACCM(0, "ACCM", "ACCM"),

	/**
	 * The '<em><b>ACCT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACCT_VALUE
	 * @generated
	 * @ordered
	 */
	ACCT(1, "ACCT", "ACCT"),

	/**
	 * The '<em><b>ACSN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACSN_VALUE
	 * @generated
	 * @ordered
	 */
	ACSN(2, "ACSN", "ACSN"),

	/**
	 * The '<em><b>ACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACT_VALUE
	 * @generated
	 * @ordered
	 */
	ACT(3, "ACT", "ACT"),

	/**
	 * The '<em><b>ACTN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTN_VALUE
	 * @generated
	 * @ordered
	 */
	ACTN(4, "ACTN", "ACTN"),

	/**
	 * The '<em><b>ADJUD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ADJUD_VALUE
	 * @generated
	 * @ordered
	 */
	ADJUD(5, "ADJUD", "ADJUD"),

	/**
	 * The '<em><b>ALRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ALRT_VALUE
	 * @generated
	 * @ordered
	 */
	ALRT(6, "ALRT", "ALRT"),

	/**
	 * The '<em><b>BATTERY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BATTERY_VALUE
	 * @generated
	 * @ordered
	 */
	BATTERY(7, "BATTERY", "BATTERY"),

	/**
	 * The '<em><b>CACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CACT_VALUE
	 * @generated
	 * @ordered
	 */
	CACT(8, "CACT", "CACT"),

	/**
	 * The '<em><b>CASE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CASE_VALUE
	 * @generated
	 * @ordered
	 */
	CASE(9, "CASE", "CASE"),

	/**
	 * The '<em><b>CATEGORY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CATEGORY_VALUE
	 * @generated
	 * @ordered
	 */
	CATEGORY(10, "CATEGORY", "CATEGORY"),

	/**
	 * The '<em><b>CDALVLONE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CDALVLONE_VALUE
	 * @generated
	 * @ordered
	 */
	CDALVLONE(11, "CDALVLONE", "CDALVLONE"),

	/**
	 * The '<em><b>CLNTRL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLNTRL_VALUE
	 * @generated
	 * @ordered
	 */
	CLNTRL(12, "CLNTRL", "CLNTRL"),

	/**
	 * The '<em><b>CLUSTER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLUSTER_VALUE
	 * @generated
	 * @ordered
	 */
	CLUSTER(13, "CLUSTER", "CLUSTER"),

	/**
	 * The '<em><b>CNOD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CNOD_VALUE
	 * @generated
	 * @ordered
	 */
	CNOD(14, "CNOD", "CNOD"),

	/**
	 * The '<em><b>CNTRCT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CNTRCT_VALUE
	 * @generated
	 * @ordered
	 */
	CNTRCT(15, "CNTRCT", "CNTRCT"),

	/**
	 * The '<em><b>COMPOSITION</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPOSITION_VALUE
	 * @generated
	 * @ordered
	 */
	COMPOSITION(16, "COMPOSITION", "COMPOSITION"),

	/**
	 * The '<em><b>COND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COND_VALUE
	 * @generated
	 * @ordered
	 */
	COND(17, "COND", "COND"),

	/**
	 * The '<em><b>CONS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONS_VALUE
	 * @generated
	 * @ordered
	 */
	CONS(18, "CONS", "CONS"),

	/**
	 * The '<em><b>CONTREG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONTREG_VALUE
	 * @generated
	 * @ordered
	 */
	CONTREG(19, "CONTREG", "CONTREG"),

	/**
	 * The '<em><b>COV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COV_VALUE
	 * @generated
	 * @ordered
	 */
	COV(20, "COV", "COV"),

	/**
	 * The '<em><b>CTTEVENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CTTEVENT_VALUE
	 * @generated
	 * @ordered
	 */
	CTTEVENT(21, "CTTEVENT", "CTTEVENT"),

	/**
	 * The '<em><b>DGIMG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DGIMG_VALUE
	 * @generated
	 * @ordered
	 */
	DGIMG(22, "DGIMG", "DGIMG"),

	/**
	 * The '<em><b>DIET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DIET_VALUE
	 * @generated
	 * @ordered
	 */
	DIET(23, "DIET", "DIET"),

	/**
	 * The '<em><b>DISPACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DISPACT_VALUE
	 * @generated
	 * @ordered
	 */
	DISPACT(24, "DISPACT", "DISPACT"),

	/**
	 * The '<em><b>DOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DOC_VALUE
	 * @generated
	 * @ordered
	 */
	DOC(25, "DOC", "DOC"),

	/**
	 * The '<em><b>DOCBODY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DOCBODY_VALUE
	 * @generated
	 * @ordered
	 */
	DOCBODY(26, "DOCBODY", "DOCBODY"),

	/**
	 * The '<em><b>DOCCLIN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DOCCLIN_VALUE
	 * @generated
	 * @ordered
	 */
	DOCCLIN(27, "DOCCLIN", "DOCCLIN"),

	/**
	 * The '<em><b>DOCSECT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DOCSECT_VALUE
	 * @generated
	 * @ordered
	 */
	DOCSECT(28, "DOCSECT", "DOCSECT"),

	/**
	 * The '<em><b>EHR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EHR_VALUE
	 * @generated
	 * @ordered
	 */
	EHR(29, "EHR", "EHR"),

	/**
	 * The '<em><b>ENC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENC_VALUE
	 * @generated
	 * @ordered
	 */
	ENC(30, "ENC", "ENC"),

	/**
	 * The '<em><b>ENTRY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENTRY_VALUE
	 * @generated
	 * @ordered
	 */
	ENTRY(31, "ENTRY", "ENTRY"),

	/**
	 * The '<em><b>EXTRACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXTRACT_VALUE
	 * @generated
	 * @ordered
	 */
	EXTRACT(32, "EXTRACT", "EXTRACT"),

	/**
	 * The '<em><b>FCNTRCT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FCNTRCT_VALUE
	 * @generated
	 * @ordered
	 */
	FCNTRCT(33, "FCNTRCT", "FCNTRCT"),

	/**
	 * The '<em><b>FOLDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FOLDER_VALUE
	 * @generated
	 * @ordered
	 */
	FOLDER(34, "FOLDER", "FOLDER"),

	/**
	 * The '<em><b>INC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INC_VALUE
	 * @generated
	 * @ordered
	 */
	INC(35, "INC", "INC"),

	/**
	 * The '<em><b>INFO</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INFO_VALUE
	 * @generated
	 * @ordered
	 */
	INFO(36, "INFO", "INFO"),

	/**
	 * The '<em><b>INFRM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INFRM_VALUE
	 * @generated
	 * @ordered
	 */
	INFRM(37, "INFRM", "INFRM"),

	/**
	 * The '<em><b>INVE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVE_VALUE
	 * @generated
	 * @ordered
	 */
	INVE(38, "INVE", "INVE"),

	/**
	 * The '<em><b>INVSTG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVSTG_VALUE
	 * @generated
	 * @ordered
	 */
	INVSTG(39, "INVSTG", "INVSTG"),

	/**
	 * The '<em><b>LIST</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIST_VALUE
	 * @generated
	 * @ordered
	 */
	LIST(40, "LIST", "LIST"),

	/**
	 * The '<em><b>MPROT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MPROT_VALUE
	 * @generated
	 * @ordered
	 */
	MPROT(41, "MPROT", "MPROT"),

	/**
	 * The '<em><b>OBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBS_VALUE
	 * @generated
	 * @ordered
	 */
	OBS(42, "OBS", "OBS"),

	/**
	 * The '<em><b>OBSCOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBSCOR_VALUE
	 * @generated
	 * @ordered
	 */
	OBSCOR(43, "OBSCOR", "OBSCOR"),

	/**
	 * The '<em><b>OBSSER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBSSER_VALUE
	 * @generated
	 * @ordered
	 */
	OBSSER(44, "OBSSER", "OBSSER"),

	/**
	 * The '<em><b>ORGANIZER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ORGANIZER_VALUE
	 * @generated
	 * @ordered
	 */
	ORGANIZER(45, "ORGANIZER", "ORGANIZER"),

	/**
	 * The '<em><b>OUTB</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OUTB_VALUE
	 * @generated
	 * @ordered
	 */
	OUTB(46, "OUTB", "OUTB"),

	/**
	 * The '<em><b>PCPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PCPR_VALUE
	 * @generated
	 * @ordered
	 */
	PCPR(47, "PCPR", "PCPR"),

	/**
	 * The '<em><b>PROC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROC_VALUE
	 * @generated
	 * @ordered
	 */
	PROC(48, "PROC", "PROC"),

	/**
	 * The '<em><b>REG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REG_VALUE
	 * @generated
	 * @ordered
	 */
	REG(49, "REG", "REG"),

	/**
	 * The '<em><b>REV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REV_VALUE
	 * @generated
	 * @ordered
	 */
	REV(50, "REV", "REV"),

	/**
	 * The '<em><b>ROIBND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROIBND_VALUE
	 * @generated
	 * @ordered
	 */
	ROIBND(51, "ROIBND", "ROIBND"),

	/**
	 * The '<em><b>ROIOVL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROIOVL_VALUE
	 * @generated
	 * @ordered
	 */
	ROIOVL(52, "ROIOVL", "ROIOVL"),

	/**
	 * The '<em><b>SBADM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SBADM_VALUE
	 * @generated
	 * @ordered
	 */
	SBADM(53, "SBADM", "SBADM"),

	/**
	 * The '<em><b>SEQ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SEQ_VALUE
	 * @generated
	 * @ordered
	 */
	SEQ(54, "SEQ", "SEQ"),

	/**
	 * The '<em><b>SEQVAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SEQVAR_VALUE
	 * @generated
	 * @ordered
	 */
	SEQVAR(55, "SEQVAR", "SEQVAR"),

	/**
	 * The '<em><b>SFWL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SFWL_VALUE
	 * @generated
	 * @ordered
	 */
	SFWL(56, "SFWL", "SFWL"),

	/**
	 * The '<em><b>SIT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIT_VALUE
	 * @generated
	 * @ordered
	 */
	SIT(57, "SIT", "SIT"),

	/**
	 * The '<em><b>SPCOBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPCOBS_VALUE
	 * @generated
	 * @ordered
	 */
	SPCOBS(58, "SPCOBS", "SPCOBS"),

	/**
	 * The '<em><b>SPCTRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPCTRT_VALUE
	 * @generated
	 * @ordered
	 */
	SPCTRT(59, "SPCTRT", "SPCTRT"),

	/**
	 * The '<em><b>SPECCOLLECT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPECCOLLECT_VALUE
	 * @generated
	 * @ordered
	 */
	SPECCOLLECT(60, "SPECCOLLECT", "SPECCOLLECT"),

	/**
	 * The '<em><b>SPLY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPLY_VALUE
	 * @generated
	 * @ordered
	 */
	SPLY(61, "SPLY", "SPLY"),

	/**
	 * The '<em><b>STC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STC_VALUE
	 * @generated
	 * @ordered
	 */
	STC(62, "STC", "STC"),

	/**
	 * The '<em><b>STDPOL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STDPOL_VALUE
	 * @generated
	 * @ordered
	 */
	STDPOL(63, "STDPOL", "STDPOL"),

	/**
	 * The '<em><b>SUBST</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUBST_VALUE
	 * @generated
	 * @ordered
	 */
	SUBST(64, "SUBST", "SUBST"),

	/**
	 * The '<em><b>TOPIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TOPIC_VALUE
	 * @generated
	 * @ordered
	 */
	TOPIC(65, "TOPIC", "TOPIC"),

	/**
	 * The '<em><b>TRNS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TRNS_VALUE
	 * @generated
	 * @ordered
	 */
	TRNS(66, "TRNS", "TRNS"),

	/**
	 * The '<em><b>VERIF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VERIF_VALUE
	 * @generated
	 * @ordered
	 */
	VERIF(67, "VERIF", "VERIF"),

	/**
	 * The '<em><b>XACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #XACT_VALUE
	 * @generated
	 * @ordered
	 */
	XACT(68, "XACT", "XACT");

	/**
	 * The '<em><b>ACCM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACCM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACCM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACCM_VALUE = 0;

	/**
	 * The '<em><b>ACCT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACCT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACCT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACCT_VALUE = 1;

	/**
	 * The '<em><b>ACSN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACSN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACSN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACSN_VALUE = 2;

	/**
	 * The '<em><b>ACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACT_VALUE = 3;

	/**
	 * The '<em><b>ACTN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTN_VALUE = 4;

	/**
	 * The '<em><b>ADJUD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ADJUD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ADJUD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ADJUD_VALUE = 5;

	/**
	 * The '<em><b>ALRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ALRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ALRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ALRT_VALUE = 6;

	/**
	 * The '<em><b>BATTERY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BATTERY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BATTERY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BATTERY_VALUE = 7;

	/**
	 * The '<em><b>CACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CACT_VALUE = 8;

	/**
	 * The '<em><b>CASE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CASE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CASE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CASE_VALUE = 9;

	/**
	 * The '<em><b>CATEGORY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CATEGORY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CATEGORY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CATEGORY_VALUE = 10;

	/**
	 * The '<em><b>CDALVLONE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CDALVLONE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CDALVLONE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CDALVLONE_VALUE = 11;

	/**
	 * The '<em><b>CLNTRL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CLNTRL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLNTRL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CLNTRL_VALUE = 12;

	/**
	 * The '<em><b>CLUSTER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CLUSTER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLUSTER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CLUSTER_VALUE = 13;

	/**
	 * The '<em><b>CNOD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CNOD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CNOD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CNOD_VALUE = 14;

	/**
	 * The '<em><b>CNTRCT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CNTRCT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CNTRCT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CNTRCT_VALUE = 15;

	/**
	 * The '<em><b>COMPOSITION</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COMPOSITION</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPOSITION
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COMPOSITION_VALUE = 16;

	/**
	 * The '<em><b>COND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COND</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COND_VALUE = 17;

	/**
	 * The '<em><b>CONS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CONS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CONS_VALUE = 18;

	/**
	 * The '<em><b>CONTREG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CONTREG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONTREG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CONTREG_VALUE = 19;

	/**
	 * The '<em><b>COV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COV_VALUE = 20;

	/**
	 * The '<em><b>CTTEVENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CTTEVENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CTTEVENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CTTEVENT_VALUE = 21;

	/**
	 * The '<em><b>DGIMG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DGIMG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DGIMG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DGIMG_VALUE = 22;

	/**
	 * The '<em><b>DIET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DIET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DIET
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DIET_VALUE = 23;

	/**
	 * The '<em><b>DISPACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DISPACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DISPACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DISPACT_VALUE = 24;

	/**
	 * The '<em><b>DOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DOC_VALUE = 25;

	/**
	 * The '<em><b>DOCBODY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DOCBODY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DOCBODY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DOCBODY_VALUE = 26;

	/**
	 * The '<em><b>DOCCLIN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DOCCLIN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DOCCLIN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DOCCLIN_VALUE = 27;

	/**
	 * The '<em><b>DOCSECT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DOCSECT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DOCSECT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DOCSECT_VALUE = 28;

	/**
	 * The '<em><b>EHR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EHR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EHR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EHR_VALUE = 29;

	/**
	 * The '<em><b>ENC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ENC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ENC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ENC_VALUE = 30;

	/**
	 * The '<em><b>ENTRY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ENTRY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ENTRY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ENTRY_VALUE = 31;

	/**
	 * The '<em><b>EXTRACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXTRACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXTRACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXTRACT_VALUE = 32;

	/**
	 * The '<em><b>FCNTRCT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FCNTRCT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FCNTRCT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FCNTRCT_VALUE = 33;

	/**
	 * The '<em><b>FOLDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FOLDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FOLDER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FOLDER_VALUE = 34;

	/**
	 * The '<em><b>INC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INC_VALUE = 35;

	/**
	 * The '<em><b>INFO</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INFO</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INFO
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INFO_VALUE = 36;

	/**
	 * The '<em><b>INFRM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INFRM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INFRM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INFRM_VALUE = 37;

	/**
	 * The '<em><b>INVE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVE_VALUE = 38;

	/**
	 * The '<em><b>INVSTG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVSTG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVSTG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVSTG_VALUE = 39;

	/**
	 * The '<em><b>LIST</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LIST</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIST
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LIST_VALUE = 40;

	/**
	 * The '<em><b>MPROT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MPROT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MPROT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MPROT_VALUE = 41;

	/**
	 * The '<em><b>OBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBS_VALUE = 42;

	/**
	 * The '<em><b>OBSCOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBSCOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBSCOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBSCOR_VALUE = 43;

	/**
	 * The '<em><b>OBSSER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBSSER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBSSER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBSSER_VALUE = 44;

	/**
	 * The '<em><b>ORGANIZER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ORGANIZER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ORGANIZER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ORGANIZER_VALUE = 45;

	/**
	 * The '<em><b>OUTB</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OUTB</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OUTB
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OUTB_VALUE = 46;

	/**
	 * The '<em><b>PCPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PCPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PCPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PCPR_VALUE = 47;

	/**
	 * The '<em><b>PROC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROC_VALUE = 48;

	/**
	 * The '<em><b>REG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REG_VALUE = 49;

	/**
	 * The '<em><b>REV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REV_VALUE = 50;

	/**
	 * The '<em><b>ROIBND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROIBND</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROIBND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROIBND_VALUE = 51;

	/**
	 * The '<em><b>ROIOVL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROIOVL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROIOVL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROIOVL_VALUE = 52;

	/**
	 * The '<em><b>SBADM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SBADM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SBADM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SBADM_VALUE = 53;

	/**
	 * The '<em><b>SEQ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SEQ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SEQ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SEQ_VALUE = 54;

	/**
	 * The '<em><b>SEQVAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SEQVAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SEQVAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SEQVAR_VALUE = 55;

	/**
	 * The '<em><b>SFWL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SFWL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SFWL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SFWL_VALUE = 56;

	/**
	 * The '<em><b>SIT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SIT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SIT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SIT_VALUE = 57;

	/**
	 * The '<em><b>SPCOBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPCOBS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPCOBS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPCOBS_VALUE = 58;

	/**
	 * The '<em><b>SPCTRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPCTRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPCTRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPCTRT_VALUE = 59;

	/**
	 * The '<em><b>SPECCOLLECT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPECCOLLECT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPECCOLLECT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPECCOLLECT_VALUE = 60;

	/**
	 * The '<em><b>SPLY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPLY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPLY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPLY_VALUE = 61;

	/**
	 * The '<em><b>STC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STC_VALUE = 62;

	/**
	 * The '<em><b>STDPOL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STDPOL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STDPOL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STDPOL_VALUE = 63;

	/**
	 * The '<em><b>SUBST</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SUBST</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SUBST
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SUBST_VALUE = 64;

	/**
	 * The '<em><b>TOPIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>TOPIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TOPIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TOPIC_VALUE = 65;

	/**
	 * The '<em><b>TRNS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>TRNS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TRNS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TRNS_VALUE = 66;

	/**
	 * The '<em><b>VERIF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>VERIF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #VERIF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VERIF_VALUE = 67;

	/**
	 * The '<em><b>XACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>XACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #XACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int XACT_VALUE = 68;

	/**
	 * An array of all the '<em><b>Act Class</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ActClass[] VALUES_ARRAY = new ActClass[] {
			ACCM, ACCT, ACSN, ACT, ACTN, ADJUD, ALRT, BATTERY, CACT, CASE, CATEGORY, CDALVLONE, CLNTRL, CLUSTER, CNOD,
			CNTRCT, COMPOSITION, COND, CONS, CONTREG, COV, CTTEVENT, DGIMG, DIET, DISPACT, DOC, DOCBODY, DOCCLIN,
			DOCSECT, EHR, ENC, ENTRY, EXTRACT, FCNTRCT, FOLDER, INC, INFO, INFRM, INVE, INVSTG, LIST, MPROT, OBS,
			OBSCOR, OBSSER, ORGANIZER, OUTB, PCPR, PROC, REG, REV, ROIBND, ROIOVL, SBADM, SEQ, SEQVAR, SFWL, SIT,
			SPCOBS, SPCTRT, SPECCOLLECT, SPLY, STC, STDPOL, SUBST, TOPIC, TRNS, VERIF, XACT, };

	/**
	 * A public read-only list of all the '<em><b>Act Class</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ActClass> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Act Class</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClass get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActClass result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Act Class</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClass getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActClass result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Act Class</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClass get(int value) {
		switch (value) {
			case ACCM_VALUE:
				return ACCM;
			case ACCT_VALUE:
				return ACCT;
			case ACSN_VALUE:
				return ACSN;
			case ACT_VALUE:
				return ACT;
			case ACTN_VALUE:
				return ACTN;
			case ADJUD_VALUE:
				return ADJUD;
			case ALRT_VALUE:
				return ALRT;
			case BATTERY_VALUE:
				return BATTERY;
			case CACT_VALUE:
				return CACT;
			case CASE_VALUE:
				return CASE;
			case CATEGORY_VALUE:
				return CATEGORY;
			case CDALVLONE_VALUE:
				return CDALVLONE;
			case CLNTRL_VALUE:
				return CLNTRL;
			case CLUSTER_VALUE:
				return CLUSTER;
			case CNOD_VALUE:
				return CNOD;
			case CNTRCT_VALUE:
				return CNTRCT;
			case COMPOSITION_VALUE:
				return COMPOSITION;
			case COND_VALUE:
				return COND;
			case CONS_VALUE:
				return CONS;
			case CONTREG_VALUE:
				return CONTREG;
			case COV_VALUE:
				return COV;
			case CTTEVENT_VALUE:
				return CTTEVENT;
			case DGIMG_VALUE:
				return DGIMG;
			case DIET_VALUE:
				return DIET;
			case DISPACT_VALUE:
				return DISPACT;
			case DOC_VALUE:
				return DOC;
			case DOCBODY_VALUE:
				return DOCBODY;
			case DOCCLIN_VALUE:
				return DOCCLIN;
			case DOCSECT_VALUE:
				return DOCSECT;
			case EHR_VALUE:
				return EHR;
			case ENC_VALUE:
				return ENC;
			case ENTRY_VALUE:
				return ENTRY;
			case EXTRACT_VALUE:
				return EXTRACT;
			case FCNTRCT_VALUE:
				return FCNTRCT;
			case FOLDER_VALUE:
				return FOLDER;
			case INC_VALUE:
				return INC;
			case INFO_VALUE:
				return INFO;
			case INFRM_VALUE:
				return INFRM;
			case INVE_VALUE:
				return INVE;
			case INVSTG_VALUE:
				return INVSTG;
			case LIST_VALUE:
				return LIST;
			case MPROT_VALUE:
				return MPROT;
			case OBS_VALUE:
				return OBS;
			case OBSCOR_VALUE:
				return OBSCOR;
			case OBSSER_VALUE:
				return OBSSER;
			case ORGANIZER_VALUE:
				return ORGANIZER;
			case OUTB_VALUE:
				return OUTB;
			case PCPR_VALUE:
				return PCPR;
			case PROC_VALUE:
				return PROC;
			case REG_VALUE:
				return REG;
			case REV_VALUE:
				return REV;
			case ROIBND_VALUE:
				return ROIBND;
			case ROIOVL_VALUE:
				return ROIOVL;
			case SBADM_VALUE:
				return SBADM;
			case SEQ_VALUE:
				return SEQ;
			case SEQVAR_VALUE:
				return SEQVAR;
			case SFWL_VALUE:
				return SFWL;
			case SIT_VALUE:
				return SIT;
			case SPCOBS_VALUE:
				return SPCOBS;
			case SPCTRT_VALUE:
				return SPCTRT;
			case SPECCOLLECT_VALUE:
				return SPECCOLLECT;
			case SPLY_VALUE:
				return SPLY;
			case STC_VALUE:
				return STC;
			case STDPOL_VALUE:
				return STDPOL;
			case SUBST_VALUE:
				return SUBST;
			case TOPIC_VALUE:
				return TOPIC;
			case TRNS_VALUE:
				return TRNS;
			case VERIF_VALUE:
				return VERIF;
			case XACT_VALUE:
				return XACT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ActClass(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // ActClass
